/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.properties.locator;

import com.liferay.properties.locator.PropertiesLocator;
import com.liferay.properties.locator.PropertiesLocatorArgs;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.SortedSet;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class PropertiesLocatorTest {
    private static final File _buildDir = new File(System.getProperty("buildDir"));
    private static final File _liferayHome = new File(System.getProperty("liferay.home"));

    @BeforeClass
    public static void readSystemProperties() throws Exception {
        Assert.assertNotNull((String)"Expecting liferay.home system property to not be null", (Object)_liferayHome);
    }

    @Test
    public void testPropertiesLocatorAPI() throws Exception {
        PropertiesLocatorArgs args = new PropertiesLocatorArgs();
        args.setBundleDir(_liferayHome);
        args.setPropertiesFile(new File("test-resources/6.2-fix-pack-131/portal.properties"));
        args.setQuiet(true);
        PropertiesLocator propertiesLocator = new PropertiesLocator(args);
        SortedSet problems = propertiesLocator.getProblems();
        Assert.assertNotNull((Object)problems);
        Assert.assertEquals((String)problems.toString(), (long)627L, (long)problems.size());
    }

    @Test
    public void testPropertiesLocatorOutputFile() throws Exception {
        int versionNumber;
        String version = System.getProperty("java.specification.version");
        if (version.indexOf(46) > -1) {
            version = version.substring(version.indexOf(46) + 1);
        }
        Assume.assumeTrue(((versionNumber = Integer.parseInt(version)) > 8 ? 1 : 0) != 0);
        File outputFile = new File(_buildDir, "testProperties.out");
        String[] args = new String[]{"-p", "test-resources/6.2-fix-pack-131/portal.properties", "-d", _liferayHome.getAbsolutePath(), "-o", outputFile.getAbsolutePath()};
        PropertiesLocator.main((String[])args);
        Path propertiesPath = Paths.get("test-resources/checkProperties.out", new String[0]);
        String expectedOutput = new String(Files.readAllBytes(propertiesPath));
        String testOutput = new String(Files.readAllBytes(outputFile.toPath()));
        Assert.assertEquals((Object)expectedOutput.replaceAll("\\r", ""), (Object)testOutput.replaceAll("\\r", ""));
    }
}

