/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.BladeTest;
import com.liferay.blade.cli.StringPrintStream;
import com.liferay.blade.cli.command.BaseArgs;
import com.liferay.blade.cli.command.InstallExtensionArgs;
import com.liferay.blade.cli.command.InstallExtensionCommand;
import com.liferay.blade.cli.gradle.GradleExec;
import com.liferay.blade.cli.gradle.ProcessResult;
import java.io.File;
import java.util.HashMap;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.rule.PowerMockRule;

@PowerMockIgnore(value={"java.util.ServiceLoader", "com.liferay.blade.cli.WorkspaceProvider", "com.liferay.blade.cli.gradle.GradleWorkspaceProvider"})
@PrepareForTest(value={InstallExtensionCommand.class, BladeCLI.class, BladeTest.class})
public class GradlePrintErrorTest {
    @Rule
    public final PowerMockRule rule = new PowerMockRule();
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File _extensionsDir = null;
    private File _rootDir = null;

    @Before
    public void setUp() throws Exception {
        this._rootDir = this.temporaryFolder.getRoot();
        this._extensionsDir = this.temporaryFolder.newFolder(new String[]{".blade", "extensions"});
    }

    @Test
    public void testGradleError() throws Exception {
        String[] args = new String[]{"extension", "install", "https://github.com/gamerson/blade-sample-command"};
        BladeTest.BladeTestBuilder bladeTestBuilder = BladeTest.builder();
        bladeTestBuilder.setExtensionsDir(this._extensionsDir.toPath());
        bladeTestBuilder.setSettingsDir(this._rootDir.toPath());
        bladeTestBuilder.setAssertErrors(false);
        BladeTest bladeTest = bladeTestBuilder.build();
        PowerMock.mockStaticPartialNice(BladeCLI.class, (String[])new String[]{"getCommandMapByClassLoader"});
        InstallExtensionCommand command = new InstallExtensionCommand();
        command.setArgs((BaseArgs)new InstallExtensionArgs());
        HashMap<String, InstallExtensionCommand> commandMap = new HashMap<String, InstallExtensionCommand>();
        commandMap.put("extension install", command);
        IExpectationSetters expect = EasyMock.expect((Object)BladeCLI.getCommandMapByClassLoader((String)EasyMock.anyString(), (ClassLoader)((ClassLoader)EasyMock.isA(ClassLoader.class))));
        IExpectationSetters expectation = expect.andReturn(commandMap);
        expectation.atLeastOnce();
        IExpectationSetters expectationNew = PowerMock.expectNew(GradleExec.class, (Object[])new Object[]{EasyMock.isA(BladeTest.class)});
        expectationNew.andReturn((Object)new GradleExecSpecial(bladeTest));
        PowerMock.replay((Object[])new Object[]{BladeCLI.class, GradleExec.class});
        bladeTest.run(args);
        StringPrintStream errPrintStream = (StringPrintStream)bladeTest.error();
        String error = errPrintStream.toString();
        error = error.toLowerCase();
        Assert.assertTrue((String)error, (boolean)error.contains("build failed"));
        Assert.assertTrue((String)error, (boolean)error.contains("foobar"));
        PowerMock.verifyAll();
    }

    private static class GradleExecSpecial
    extends GradleExec {
        public GradleExecSpecial(BladeCLI blade) {
            super(blade);
        }

        public ProcessResult executeTask(String cmd, File dir) throws Exception {
            cmd = cmd.replace("assemble", "foobar");
            return super.executeTask(cmd, dir);
        }
    }
}

