/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli;

import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.BladeSettings;
import com.liferay.blade.cli.StringPrintStream;
import com.liferay.blade.cli.WorkspaceProvider;
import com.liferay.blade.cli.command.BaseArgs;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Scanner;
import java.util.stream.Stream;

public class BladeTest
extends BladeCLI {
    private static final String _BLADE_PROPERTIES = ".blade.properties";
    private boolean _assertErrors = true;
    private Path _extensionsDir;
    private Path _settingsDir;

    public static BladeTestBuilder builder() {
        return new BladeTestBuilder();
    }

    public BladeSettings getBladeSettings() throws IOException {
        String name;
        File settingsBaseDir = this._getSettingsBaseDir();
        File settingsFile = new File(settingsBaseDir, ".blade/settings.properties");
        if (settingsFile.exists() && Objects.equals("settings.properties", name = settingsFile.getName())) {
            this._migrateBladeSettingsFile(settingsFile);
        }
        settingsFile = new File(settingsBaseDir, _BLADE_PROPERTIES);
        return new BladeSettings(settingsFile);
    }

    public Path getExtensionsPath() {
        try {
            Files.createDirectories(this._extensionsDir, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this._extensionsDir;
    }

    public void postRunCommand() {
    }

    public void run(String[] args) throws Exception {
        PrintStream error;
        super.run(args);
        if (this._assertErrors && (error = this.error()) instanceof StringPrintStream) {
            StringPrintStream stringPrintStream = (StringPrintStream)error;
            String errors = stringPrintStream.get();
            errors = errors.trim();
            StringBuilder sb = new StringBuilder();
            boolean bridj = false;
            try (Scanner scanner = new Scanner(errors);){
                while (scanner.hasNextLine() && !bridj) {
                    String line = scanner.nextLine();
                    if (line == null || line.length() <= 0) continue;
                    if (line.contains("org/bridj/Platform$DeleteFiles")) {
                        bridj = true;
                        continue;
                    }
                    if (line.contains("org.bridj.BridJ log") || line.startsWith("SLF4J:") || line.startsWith("Picked up JAVA_TOOL_OPTIONS") || line.contains("LC_ALL: cannot change locale")) continue;
                    sb.append(line);
                    if (!scanner.hasNextLine()) continue;
                    sb.append(System.lineSeparator());
                }
            }
            errors = sb.toString();
            if (!(errors = errors.replaceAll("^\\/bin\\/$", "")).isEmpty()) {
                throw new Exception("\nErrors not empty:\n" + errors);
            }
        }
    }

    protected BladeTest(PrintStream out, PrintStream err, InputStream in) {
        super(out, err, in);
    }

    private File _getSettingsBaseDir() {
        BaseArgs args = this.getArgs();
        File baseDir = new File(args.getBase());
        WorkspaceProvider workspaceProvider = this.getWorkspaceProvider(baseDir);
        File settingsBaseDir = workspaceProvider != null ? workspaceProvider.getWorkspaceDir(baseDir) : this._settingsDir.toFile();
        return settingsBaseDir;
    }

    private void _migrateBladeSettingsFile(File settingsFile) throws IOException {
        Path settingsPath = settingsFile.toPath();
        Path settingsParentPath = settingsPath.getParent();
        if (settingsParentPath.endsWith(".blade")) {
            Path settingsParentParentPath = settingsParentPath.getParent();
            Path newSettingsPath = settingsParentParentPath.resolve(_BLADE_PROPERTIES);
            Files.move(settingsPath, newSettingsPath, new CopyOption[0]);
            try (Stream<Path> filesStream = Files.list(settingsParentPath);){
                if (filesStream.count() == 0L) {
                    Files.delete(settingsParentPath);
                }
            }
        }
    }

    public static class BladeTestBuilder {
        private boolean _assertErrors = true;
        private Path _extensionsDir = null;
        private Path _settingsDir = null;
        private PrintStream _stdError = null;
        private InputStream _stdIn = null;
        private PrintStream _stdOut = null;
        private Path _userHomePath = Paths.get(System.getProperty("user.home"), new String[0]);

        public BladeTest build() {
            if (this._extensionsDir == null) {
                this._extensionsDir = this._userHomePath.resolve(".blade/extensions");
            }
            if (this._settingsDir == null) {
                this._settingsDir = this._userHomePath.resolve(".blade");
            }
            if (this._stdIn == null) {
                this._stdIn = System.in;
            }
            if (this._stdOut == null) {
                this._stdOut = StringPrintStream.newInstance();
            }
            if (this._stdError == null) {
                this._stdError = StringPrintStream.newInstance();
            }
            BladeTest bladeTest = new BladeTest(this._stdOut, this._stdError, this._stdIn);
            bladeTest._assertErrors = this._assertErrors;
            bladeTest._extensionsDir = this._extensionsDir;
            bladeTest._settingsDir = this._settingsDir;
            return bladeTest;
        }

        public void setAssertErrors(boolean assertErrors) {
            this._assertErrors = assertErrors;
        }

        public void setExtensionsDir(Path extensionsDir) {
            this._extensionsDir = extensionsDir;
        }

        public void setSettingsDir(Path settingsDir) {
            this._settingsDir = settingsDir;
        }

        public void setStdError(PrintStream printStream) {
            this._stdError = printStream;
        }

        public void setStdIn(InputStream inputStream) {
            this._stdIn = inputStream;
        }

        public void setStdOut(PrintStream printStream) {
            this._stdOut = printStream;
        }
    }
}

