/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeTestResults;
import com.liferay.blade.cli.TestUtil;
import com.liferay.blade.cli.command.UpdateArgs;
import com.liferay.blade.cli.command.UpdateCommand;
import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class UpdateCommandTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File _extensionsDir = null;
    private File _rootDir = null;

    @Before
    public void setUp() throws Exception {
        this._rootDir = this.temporaryFolder.getRoot();
        this._extensionsDir = this.temporaryFolder.newFolder(new String[]{".blade", "extensions"});
    }

    @Test
    public void testCurrentMajorLessThanUpdatedMajor() {
        String currentVersion = "1.5.9.1.2.3.4.5.6.7.8.9";
        String updatedVersion = "2.1.1.4.5.6-snapshot";
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + updatedVersion), (boolean)UpdateCommand.shouldUpdate((String)currentVersion, (String)updatedVersion));
    }

    @Test
    public void testCurrentMajorMoreThanUpdatedMajor() {
        String currentVersion = "3.0.0.2018.10.23.1234";
        String updatedVersion = "2.5.9-SNAPSHOT";
        Assert.assertFalse((String)("currentVersion = " + currentVersion + " should NOT be updated to " + updatedVersion), (boolean)UpdateCommand.shouldUpdate((String)currentVersion, (String)updatedVersion));
    }

    @Test
    public void testCurrentMinorLessThanUpdatedMinor() {
        String currentVersion = "12.1.9.SCHWIBBY";
        String updatedVersion = "12.2.1-snapshot";
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + updatedVersion), (boolean)UpdateCommand.shouldUpdate((String)currentVersion, (String)updatedVersion));
    }

    @Test
    public void testCurrentMinorMoreThanUpdatedMinor() {
        String currentVersion = "3.6.0.001810231234";
        String updatedVersion = "3.5.9-SCHNAPS";
        Assert.assertFalse((String)("currentVersion = " + currentVersion + " should NOT be updated to " + updatedVersion), (boolean)UpdateCommand.shouldUpdate((String)currentVersion, (String)updatedVersion));
    }

    @Test
    public void testCurrentPatchLessThanUpdatedPatch() {
        String currentVersion = "123.10.10.SCHOOBY";
        String updatedVersion = "123.10.20-whiff";
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + updatedVersion), (boolean)UpdateCommand.shouldUpdate((String)currentVersion, (String)updatedVersion));
    }

    @Test
    public void testCurrentPatchMoreThanUpdatedPatch() {
        String currentVersion = "3.5.9.001810231234";
        String updatedVersion = "3.5.8.999999";
        Assert.assertFalse((String)("currentVersion = " + currentVersion + " should NOT be updated to " + updatedVersion), (boolean)UpdateCommand.shouldUpdate((String)currentVersion, (String)updatedVersion));
    }

    @Test
    public void testCurrentSnapshot() {
        String currentVersion = "3.4.0.SNAPSHOT201812060746";
        String updatedVersion = "3.4.0-20181206.074623-13";
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be the latest snapshot " + updatedVersion + " but it is not"), (boolean)UpdateCommand.equal((String)currentVersion, (String)updatedVersion));
    }

    @Test
    public void testCurrentVersionWithNoManifest() throws Exception {
        BladeTestResults bladeTestResults = TestUtil.runBlade(this._rootDir, this._extensionsDir, false, "version");
        String errors = bladeTestResults.getErrors();
        String expectedErrorMessage = "Could not determine version.";
        Assert.assertEquals((Object)expectedErrorMessage, (Object)errors.trim());
    }

    @Ignore
    @Test
    public void testGetUpdateVersionReleases() throws IOException {
        String updateVersion = UpdateCommand.getUpdateVersion((boolean)false);
        Assert.assertNotNull((Object)updateVersion);
        Assert.assertFalse((String)"updateVersion does not look right.", (boolean)updateVersion.isEmpty());
    }

    @Ignore
    @Test
    public void testTargetReleases() throws IOException {
        UpdateArgs updateArgs = new UpdateArgs();
        updateArgs.setSnapshots(false);
        String url = UpdateCommand.getUpdateJarUrl((UpdateArgs)updateArgs);
        boolean ok = false;
        if (url.length() > 1) {
            ok = true;
        }
        Assert.assertTrue((String)("url = " + url + " ... this does not look right."), (boolean)ok);
        Assert.assertTrue((String)("url is not from releases repo.  url = " + url), (boolean)url.contains("liferay-public-releases/"));
    }

    @Test
    public void testTargetSnapshots() throws IOException {
        UpdateArgs updateArgs = new UpdateArgs();
        updateArgs.setSnapshots(true);
        String url = UpdateCommand.getUpdateJarUrl((UpdateArgs)updateArgs);
        boolean ok = false;
        if (url.length() > 1) {
            ok = true;
        }
        Assert.assertTrue((String)("url = " + url + " ... this does not look right."), (boolean)ok);
        Assert.assertTrue((String)("url is not from snapshots repo.  url = " + url), (boolean)url.contains("liferay-public-snapshots/"));
    }

    @Test
    public void testTwoSnapshotVersions() {
        String currentVersion = "3.3.1.SNAPSHOT201811211846";
        String updateVersion = "3.3.1-20181128.214621-308";
        Assert.assertTrue((String)("currentVersion = " + currentVersion + " should be updated to " + updateVersion), (boolean)UpdateCommand.shouldUpdate((String)currentVersion, (String)updateVersion));
    }
}

