/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli;

import com.liferay.blade.cli.TestUtil;
import com.liferay.blade.cli.gradle.GradleWorkspaceProvider;
import com.liferay.blade.cli.util.BladeUtil;
import com.liferay.blade.cli.util.FileUtil;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class UtilTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testAppServerProperties() throws Exception {
        File dir = this.temporaryFolder.getRoot();
        File appServerProperty1 = new File(dir, "app.server." + System.getProperty("user.name") + ".properties");
        appServerProperty1.createNewFile();
        File appServerProperty2 = new File(dir, "app.server.properties");
        appServerProperty2.createNewFile();
        List propertiesList = BladeUtil.getAppServerProperties((File)dir);
        Assert.assertTrue((propertiesList.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testCopyEntireDirectory() throws Exception {
        File testDir1 = this.temporaryFolder.newFolder("dir1");
        File testFile1 = new File(testDir1, "1");
        File testFile2 = new File(testDir1, "2");
        File testFile3 = new File(testDir1, "3");
        testFile1.createNewFile();
        testFile2.createNewFile();
        testFile3.createNewFile();
        File testDir2 = new File(this.temporaryFolder.getRoot(), "dir2");
        FileUtil.copyDir((Path)testDir1.toPath(), (Path)testDir2.toPath());
        Assert.assertTrue((boolean)testDir2.exists());
        String[] testDir1List = testDir1.list();
        Object[] testDir2List = testDir2.list();
        Assert.assertEquals((String)Arrays.toString(testDir2List), (long)testDir1List.length, (long)testDir2List.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFindParentFile() throws Exception {
        File tempTestFile = null;
        try {
            File dir = new File(".");
            dir = dir.getAbsoluteFile();
            File parentDir = dir.getParentFile();
            File parentParentDir = parentDir.getParentFile();
            tempTestFile = new File(parentParentDir, "test.file");
            if (tempTestFile.exists()) {
                Assert.assertTrue((boolean)tempTestFile.delete());
            }
            Assert.assertTrue((boolean)tempTestFile.createNewFile());
            File fileRelative = dir;
            File foundFile = BladeUtil.findParentFile((File)fileRelative, (String[])new String[]{"test.file"}, (boolean)true);
            Assert.assertTrue((boolean)Objects.nonNull(foundFile));
        }
        finally {
            if (tempTestFile != null) {
                Files.delete(tempTestFile.toPath());
            }
        }
    }

    @Test
    public void testMigrateBladeSettings() throws Exception {
        File rootWorkspaceDir = this.temporaryFolder.newFolder("workspace");
        File extensionsDir = this.temporaryFolder.newFolder(new String[]{".blade", "extensions"});
        String[] args = new String[]{"--base", rootWorkspaceDir.getAbsolutePath(), "init", "-f", "foo"};
        File workspaceDirectory = new File(rootWorkspaceDir, "foo");
        TestUtil.runBlade(workspaceDirectory, extensionsDir, args);
        GradleWorkspaceProvider provider = new GradleWorkspaceProvider();
        boolean workspace = provider.isWorkspace(workspaceDirectory);
        Assert.assertTrue((boolean)workspace);
        File bladeSettings = new File(workspaceDirectory, ".blade.properties");
        Path bladeSettingsNewPath = bladeSettings.toPath();
        Path workspacePath = workspaceDirectory.toPath();
        Path bladeDirPath = workspacePath.resolve(".blade");
        if (!Files.exists(bladeDirPath, new LinkOption[0])) {
            Files.createDirectory(bladeDirPath, new FileAttribute[0]);
        }
        Path bladeSettingsOldPath = bladeDirPath.resolve("settings.properties");
        Files.move(bladeSettingsNewPath, bladeSettingsOldPath, new CopyOption[0]);
        boolean bladeSettingsOldPathExists = Files.exists(bladeSettingsOldPath, new LinkOption[0]);
        Assert.assertTrue((boolean)bladeSettingsOldPathExists);
        args = new String[]{"--base", workspaceDirectory.getPath(), "help"};
        TestUtil.runBlade(workspaceDirectory, extensionsDir, args);
        bladeSettingsOldPathExists = Files.exists(bladeSettingsOldPath, new LinkOption[0]);
        Assert.assertFalse((boolean)bladeSettingsOldPathExists);
        boolean bladeSettingsPathExists = Files.exists(bladeSettingsNewPath, new LinkOption[0]);
        Assert.assertTrue((boolean)bladeSettingsPathExists);
    }

    @Test
    public void testNewBladeSettings() throws Exception {
        File rootWorkspaceDir = this.temporaryFolder.newFolder("workspace");
        File extensionsDir = this.temporaryFolder.newFolder(new String[]{".blade", "extensions"});
        String[] args = new String[]{"--base", rootWorkspaceDir.getAbsolutePath(), "init", "-f", "foo"};
        File workspaceDirectory = new File(rootWorkspaceDir, "foo");
        TestUtil.runBlade(workspaceDirectory, extensionsDir, args);
        GradleWorkspaceProvider provider = new GradleWorkspaceProvider();
        boolean workspace = provider.isWorkspace(workspaceDirectory);
        Assert.assertTrue((boolean)workspace);
        File bladeSettings = new File(workspaceDirectory, ".blade.properties");
        Assert.assertTrue((boolean)bladeSettings.exists());
    }
}

