/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeTestResults;
import com.liferay.blade.cli.TestUtil;
import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class HelpCommandTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File _extensionsDir = null;
    private File _rootDir = null;

    @Before
    public void setUpTestExtensions() throws Exception {
        this._rootDir = this.temporaryFolder.getRoot();
        this._extensionsDir = this.temporaryFolder.newFolder(new String[]{".blade", "extensions"});
    }

    @Test
    public void testHelpCommand() throws Exception {
        String content = this._runBlade("help");
        Assert.assertTrue((String)content, (boolean)content.contains("Usage:"));
        Assert.assertFalse((String)content, (boolean)content.contains("--"));
    }

    @Test
    public void testHelpCommandSpecific() throws Exception {
        String content = this._runBlade("help", "create");
        Assert.assertTrue((String)content, (boolean)content.contains("Usage:"));
        Assert.assertTrue((String)content, (boolean)content.contains("--"));
    }

    @Test
    public void testHelpFlag() throws Exception {
        String content = this._runBlade("--help");
        Assert.assertTrue((String)content, (boolean)content.contains("Usage:"));
    }

    private String _runBlade(String ... args) throws Exception {
        BladeTestResults bladeTestResults = TestUtil.runBlade(this._rootDir, this._extensionsDir, args);
        String output = bladeTestResults.getOutput();
        Assert.assertFalse((String)output, (boolean)output.contains("No such command"));
        return output;
    }
}

