/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.gradle;

import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.BladeTest;
import com.liferay.blade.cli.gradle.GradleExec;
import com.liferay.blade.cli.gradle.ProcessResult;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class GradleExecTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File _extensionsDir = null;
    private File _rootDir = null;

    @Before
    public void setUp() throws Exception {
        this._rootDir = this.temporaryFolder.getRoot();
        this._extensionsDir = this.temporaryFolder.newFolder(new String[]{".blade", "extensions"});
    }

    @Test
    public void testGradleWrapper() throws Exception {
        File temporaryDir = this.temporaryFolder.getRoot();
        String[] args = new String[]{"--base", temporaryDir.getAbsolutePath(), "create", "-t", "api", "foo"};
        this._getBladeTest().run(args);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        BladeTest.BladeTestBuilder bladeTestBuilder = BladeTest.builder();
        bladeTestBuilder.setExtensionsDir(this._extensionsDir.toPath());
        bladeTestBuilder.setSettingsDir(this._rootDir.toPath());
        bladeTestBuilder.setStdOut(ps);
        BladeTest bladeCLI = bladeTestBuilder.build();
        GradleExec gradleExec = new GradleExec((BladeCLI)bladeCLI);
        ProcessResult result = gradleExec.executeTask("tasks");
        int resultCode = result.getResultCode();
        String output = result.get();
        if (resultCode > 0) {
            Assert.assertEquals((String)("Gradle command returned error code " + resultCode + System.lineSeparator() + output), (long)0L, (long)resultCode);
        } else {
            Assert.assertFalse((String)("Gradle build failed " + System.lineSeparator() + output), (boolean)output.contains("BUILD FAILED"));
        }
    }

    private BladeTest _getBladeTest() {
        BladeTest.BladeTestBuilder bladeTestBuilder = BladeTest.builder();
        bladeTestBuilder.setExtensionsDir(this._extensionsDir.toPath());
        bladeTestBuilder.setSettingsDir(this._rootDir.toPath());
        return bladeTestBuilder.build();
    }
}

