/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.TestUtil;
import com.liferay.blade.cli.command.JavaProcess;
import com.liferay.blade.cli.command.JavaProcesses;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.zeroturnaround.process.PidProcess;
import org.zeroturnaround.process.Processes;

public class ServerStartCommandTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static final String _BUNDLE_FOLDER_NAME_TOMCAT = "tomcat-9.0.10";
    private static final String _BUNDLE_FOLDER_NAME_WILDFLY = "wildfly-11.0.0";
    private static final int _DEBUG_PORT_TOMCAT = 8000;
    private static final int _DEBUG_PORT_WILDFLY = 8787;
    private static final Predicate<JavaProcess> _FILTER_TOMCAT = process -> {
        String displayName = process.getDisplayName();
        return displayName.contains("org.apache.catalina.startup.Bootstrap");
    };
    private static final Predicate<JavaProcess> _FILTER_WILDFLY = process -> {
        String displayName = process.getDisplayName();
        return displayName.contains("jboss-modules");
    };
    private static final String _LIFERAY_WORKSPACE_BUNDLE_KEY = "liferay.workspace.bundle.url";
    private static final String _LIFERAY_WORKSPACE_BUNDLE_TOMCAT = "liferay-ce-portal-tomcat-7.1.1-ga2-20181112144637000.tar.gz";
    private static final String _LIFERAY_WORKSPACE_BUNDLE_URL = "https://releases-cdn.liferay.com/portal/7.1.1-ga2/";
    private static final String _LIFERAY_WORKSPACE_BUNDLE_WILDFLY = "liferay-ce-portal-wildfly-7.1.1-ga2-20181112144637000.tar.gz";
    private Path _extensionsPath = null;
    private Path _testWorkspacePath = null;

    @Before
    public void setUp() throws Exception {
        File testWorkspaceFile = this.temporaryFolder.newFolder("testWorkspaceDir");
        this._testWorkspacePath = testWorkspaceFile.toPath();
        File extensionsFile = this.temporaryFolder.newFolder(new String[]{".blade", "extensions"});
        this._extensionsPath = extensionsFile.toPath();
    }

    @Test
    public void testServerInitCustomEnvironment() throws Exception {
        this._initBladeWorkspace();
        this._customizeProdProperties();
        this._initServerBundle("--environment", "prod");
        Path bundleConfigPath = this._getBundleConfigPath();
        this._validateBundleConfigFile(bundleConfigPath);
    }

    @Test
    public void testServerStartCommandExists() throws Exception {
        Assert.assertTrue((boolean)this._commandExists("server", "start"));
        Assert.assertTrue((boolean)this._commandExists("server start"));
        Assert.assertFalse((boolean)this._commandExists("server", "startx"));
        Assert.assertFalse((boolean)this._commandExists("server startx"));
        Assert.assertFalse((boolean)this._commandExists("serverx", "start"));
        Assert.assertFalse((boolean)this._commandExists("serverx start"));
    }

    @Test
    public void testServerStartCommandTomcat() throws Exception {
        boolean useDebugging = false;
        this._initBladeWorkspace();
        this._addTomcatBundleToGradle();
        this._initServerBundle(new String[0]);
        this._verifyTomcatBundlePath();
        this._startServer(useDebugging);
        this._findAndTerminateTomcat(useDebugging);
    }

    @Test
    public void testServerStartCommandTomcatDebug() throws Exception {
        boolean useDebugging = true;
        this._initBladeWorkspace();
        this._addTomcatBundleToGradle();
        this._initServerBundle(new String[0]);
        this._verifyTomcatBundlePath();
        this._startServer(useDebugging);
        this._findAndTerminateTomcat(useDebugging);
    }

    @Test
    public void testServerStartCommandWildfly() throws Exception {
        boolean useDebugging = false;
        this._initBladeWorkspace();
        this._addWildflyBundleToGradle();
        this._initServerBundle(new String[0]);
        this._verifyWildflyBundlePath();
        this._startServer(useDebugging);
        this._findAndTerminateWildfly(useDebugging);
    }

    @Test
    public void testServerStartCommandWildflyDebug() throws Exception {
        boolean useDebugging = true;
        this._initBladeWorkspace();
        this._addWildflyBundleToGradle();
        this._initServerBundle(new String[0]);
        this._verifyWildflyBundlePath();
        this._startServer(useDebugging);
        this._findAndTerminateWildfly(useDebugging);
    }

    @Test
    public void testServerStopCommandExists() throws Exception {
        Assert.assertTrue((boolean)this._commandExists("server", "stop"));
        Assert.assertTrue((boolean)this._commandExists("server stop"));
        Assert.assertFalse((boolean)this._commandExists("server", "stopx"));
        Assert.assertFalse((boolean)this._commandExists("server stopx"));
        Assert.assertFalse((boolean)this._commandExists("serverx", "stopx"));
        Assert.assertFalse((boolean)this._commandExists("serverx stop"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean _isDebugPortListening(int debugPort) {
        InetAddress loopbackAddress = InetAddress.getLoopbackAddress();
        try (Socket socket = new Socket(loopbackAddress, debugPort);){
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    private static void _terminateProcess(PidProcess tomcatPidProcess) throws InterruptedException, IOException {
        tomcatPidProcess.destroyForcefully();
        tomcatPidProcess.waitFor(1L, TimeUnit.SECONDS);
        String processName = tomcatPidProcess.getDescription();
        Assert.assertFalse((String)("Expected " + processName + " process to be destroyed."), (boolean)tomcatPidProcess.isAlive());
    }

    private void _addBundleToGradle(String bundleFileName) throws Exception {
        Path gradlePropertiesPath = this._testWorkspacePath.resolve("gradle.properties");
        String contents = new String(Files.readAllBytes(gradlePropertiesPath));
        StringBuilder sb = new StringBuilder();
        sb.append(_LIFERAY_WORKSPACE_BUNDLE_KEY);
        sb.append("=");
        sb.append(_LIFERAY_WORKSPACE_BUNDLE_URL);
        sb.append(bundleFileName);
        sb.append(System.lineSeparator());
        String bundleUrl = sb.toString();
        contents = bundleUrl + contents;
        Files.write(gradlePropertiesPath, bundleUrl.getBytes(), StandardOpenOption.TRUNCATE_EXISTING);
    }

    private void _addTomcatBundleToGradle() throws Exception {
        this._addBundleToGradle(_LIFERAY_WORKSPACE_BUNDLE_TOMCAT);
    }

    private void _addWildflyBundleToGradle() throws Exception {
        this._addBundleToGradle(_LIFERAY_WORKSPACE_BUNDLE_WILDFLY);
    }

    private boolean _commandExists(String ... args) {
        try {
            TestUtil.runBlade(this._testWorkspacePath, this._extensionsPath, args);
        }
        catch (Throwable throwable) {
            String message = throwable.getMessage();
            return Objects.nonNull(message) && !message.contains("No such command");
        }
        return false;
    }

    private void _customizeProdProperties() throws FileNotFoundException, IOException {
        Path prodConfigPath = this._testWorkspacePath.resolve(Paths.get("configs", "prod", "portal-ext.properties"));
        Properties portalExtProperties = new Properties();
        try (InputStream inputStream = Files.newInputStream(prodConfigPath, new OpenOption[0]);){
            portalExtProperties.load(inputStream);
        }
        portalExtProperties.put("foo.bar", "foobar");
        var4_4 = null;
        try (OutputStream outputStream = Files.newOutputStream(prodConfigPath, new OpenOption[0]);){
            portalExtProperties.store(outputStream, "");
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    private void _findAndTerminateServer(Predicate<JavaProcess> processFilter, boolean debugFlag, int debugPort) throws Exception {
        PidProcess serverProcess = this._findServerProcess(processFilter);
        boolean debugPortListening = ServerStartCommandTest._isDebugPortListening(debugPort);
        Assert.assertEquals((String)"Debug port not in a correct state", (Object)debugFlag, (Object)debugPortListening);
        ServerStartCommandTest._terminateProcess(serverProcess);
        if (debugFlag) {
            debugPortListening = ServerStartCommandTest._isDebugPortListening(debugPort);
            Assert.assertFalse((String)"Debug port should no longer be listening", (boolean)debugPortListening);
        }
    }

    private void _findAndTerminateTomcat(boolean debugFlag) throws Exception {
        this._findAndTerminateServer(_FILTER_TOMCAT, debugFlag, 8000);
    }

    private void _findAndTerminateWildfly(boolean debugFlag) throws Exception {
        this._findAndTerminateServer(_FILTER_WILDFLY, debugFlag, 8787);
    }

    private Optional<JavaProcess> _findProcess(Collection<JavaProcess> javaProcesses, Predicate<JavaProcess> processFilter) {
        Stream<JavaProcess> stream = javaProcesses.stream();
        return stream.filter(processFilter).findFirst();
    }

    private PidProcess _findServerProcess(Predicate<JavaProcess> processFilter) throws InterruptedException, IOException {
        Collection<JavaProcess> javaProcesses = JavaProcesses.list();
        Optional<JavaProcess> optionalProcess = this._findProcess(javaProcesses, processFilter);
        Assert.assertTrue((String)("Expected to find server process:\n" + this._printDisplayNames(javaProcesses)), (boolean)optionalProcess.isPresent());
        JavaProcess javaProcess = optionalProcess.get();
        String processName = javaProcess.getDisplayName();
        PidProcess pidProcess = Processes.newPidProcess((int)javaProcess.getId());
        Assert.assertTrue((String)("Expected " + processName + " process to be alive"), (boolean)pidProcess.isAlive());
        return pidProcess;
    }

    private Path _getBundleConfigPath() {
        Path bundlesFolderPath = this._testWorkspacePath.resolve("bundles");
        boolean bundlesFolderExists = Files.exists(bundlesFolderPath, new LinkOption[0]);
        Assert.assertTrue((boolean)bundlesFolderExists);
        Path bundleConfigPath = bundlesFolderPath.resolve("portal-ext.properties");
        boolean bundleConfigFileExists = Files.exists(bundleConfigPath, new LinkOption[0]);
        Assert.assertTrue((boolean)bundleConfigFileExists);
        return bundleConfigPath;
    }

    private void _initBladeWorkspace() throws Exception {
        String[] initArgs = new String[]{"--base", this._testWorkspacePath.toString(), "init", "-v", "7.1"};
        TestUtil.runBlade(this._testWorkspacePath, this._extensionsPath, initArgs);
    }

    private void _initServerBundle(String ... additionalArgs) throws Exception {
        String[] serverInitArgs = new String[]{"--base", this._testWorkspacePath.toString(), "server", "init"};
        if (additionalArgs != null && additionalArgs.length > 0) {
            List<String> serverInitArgsCollection = Arrays.asList(serverInitArgs);
            List<String> additionalArgsCollection = Arrays.asList(additionalArgs);
            serverInitArgsCollection = new ArrayList<String>(serverInitArgsCollection);
            serverInitArgsCollection.addAll(additionalArgsCollection);
            serverInitArgs = serverInitArgsCollection.toArray(new String[0]);
        }
        TestUtil.runBlade(this._testWorkspacePath, this._extensionsPath, serverInitArgs);
    }

    private String _printDisplayNames(Collection<JavaProcess> javaProcesses) {
        StringBuilder sb = new StringBuilder();
        for (JavaProcess javaProcess : javaProcesses) {
            sb.append(javaProcess.getDisplayName() + System.lineSeparator());
        }
        return sb.toString();
    }

    private void _startServer(boolean debugFlag) throws Exception, InterruptedException {
        String[] serverStartArgs = new String[]{"--base", this._testWorkspacePath.toString(), "server", "start"};
        List<String> serverStartArgsCollection = Arrays.asList(serverStartArgs);
        serverStartArgsCollection = new ArrayList<String>(serverStartArgsCollection);
        if (debugFlag) {
            serverStartArgsCollection.add("--debug");
        }
        serverStartArgs = serverStartArgsCollection.toArray(new String[0]);
        TestUtil.runBlade(this._testWorkspacePath, this._extensionsPath, serverStartArgs);
        Thread.sleep(1000L);
    }

    private void _validateBundleConfigFile(Path bundleConfigPath) throws FileNotFoundException, IOException {
        Properties runtimePortalExtProperties = new Properties();
        try (InputStream inputStream = Files.newInputStream(bundleConfigPath, new OpenOption[0]);){
            runtimePortalExtProperties.load(inputStream);
        }
        String fooBarProperty = runtimePortalExtProperties.getProperty("foo.bar");
        Assert.assertEquals((Object)"foobar", (Object)fooBarProperty);
    }

    private void _verifyBundlePath(String folderName) {
        Path bundlesPath = this._testWorkspacePath.resolve(Paths.get("bundles", folderName));
        boolean bundlesPathExists = Files.exists(bundlesPath, new LinkOption[0]);
        Assert.assertTrue((String)("Bundles folder " + bundlesPath + " must exist"), (boolean)bundlesPathExists);
    }

    private void _verifyTomcatBundlePath() {
        this._verifyBundlePath(_BUNDLE_FOLDER_NAME_TOMCAT);
    }

    private void _verifyWildflyBundlePath() {
        this._verifyBundlePath(_BUNDLE_FOLDER_NAME_WILDFLY);
    }
}

