/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli;

import com.liferay.blade.cli.util.FileUtil;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.zip.ZipException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ZipSlipTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testNoZipSlipZip() throws Exception {
        this._testZip("no-zip-slip.zip");
        File tempDir = this.temporaryFolder.getRoot();
        File expectedAFile = new File(tempDir, "afile");
        Assert.assertTrue((String)("Expected file " + expectedAFile + " not found."), (boolean)expectedAFile.exists());
        File expectedBFile = new File(tempDir, "b/bfile");
        Assert.assertTrue((String)("Expected file " + expectedBFile + " not found."), (boolean)expectedBFile.exists());
        File expectedEFile = new File(tempDir, "c/d/efile");
        Assert.assertTrue((String)("Expected file " + expectedEFile + " not found."), (boolean)expectedEFile.exists());
    }

    @Test(expected=ZipException.class)
    public void testZipSlipZip() throws Exception {
        this._testZip("zip-slip.zip");
    }

    private void _testZip(String fileName) throws Exception {
        File tempDir = this.temporaryFolder.getRoot();
        Path tempPath = tempDir.toPath();
        Path zipPath = tempPath.resolve(fileName);
        Files.copy(this.getClass().getResourceAsStream(fileName), zipPath, new CopyOption[0]);
        FileUtil.unzip((File)zipPath.toFile(), (File)tempDir);
    }
}

