/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeTest;
import com.liferay.blade.cli.util.FileUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ConvertServiceBuilderCommandTest {
    public static final String SB_PROJECT_NAME = "sample-service-builder-portlet";
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testConvertServiceBuilder() throws Exception {
        File testdir = new File(this.temporaryFolder.getRoot(), "build/testMigrateServiceBuilder");
        FileUtil.unzip((File)new File("test-resources/projects/plugins-sdk-with-git.zip"), (File)testdir);
        Assert.assertTrue((boolean)testdir.exists());
        File projectDir = new File(testdir, "plugins-sdk-with-git");
        File pluginsSdkDir = new File(projectDir, "plugins-sdk");
        FileUtil.deleteDirIfExists((Path)pluginsSdkDir.toPath());
        String[] args = new String[]{"--base", projectDir.getPath(), "init", "-u"};
        BladeTest bladeTest = new BladeTest(this.temporaryFolder.getRoot());
        bladeTest.run(args);
        args = new String[]{"--base", projectDir.getPath(), "convert", SB_PROJECT_NAME};
        bladeTest = new BladeTest(this.temporaryFolder.getRoot());
        bladeTest.run(args);
        File sbWar = new File(projectDir, "wars/sample-service-builder-portlet");
        Assert.assertTrue((boolean)sbWar.exists());
        Assert.assertFalse((boolean)new File(sbWar, "build.xml").exists());
        Assert.assertTrue((boolean)new File(sbWar, "build.gradle").exists());
        Assert.assertFalse((boolean)new File(sbWar, "docroot").exists());
        File moduleDir = new File(projectDir, "modules");
        File newSbDir = new File(moduleDir, "sample-service-builder");
        File sbServiceDir = new File(newSbDir, "sample-service-builder-service");
        File sbApiDir = new File(newSbDir, "sample-service-builder-api");
        Assert.assertTrue((boolean)sbServiceDir.exists());
        Assert.assertTrue((boolean)sbApiDir.exists());
        Assert.assertTrue((boolean)new File(sbServiceDir, "service.xml").exists());
        Assert.assertTrue((boolean)new File(sbServiceDir, "src/main/resources/service.properties").exists());
        Assert.assertTrue((boolean)new File(sbServiceDir, "src/main/resources/META-INF/portlet-model-hints.xml").exists());
        Assert.assertTrue((boolean)new File(sbServiceDir, "src/main/java/com/liferay/sampleservicebuilder/service/impl/FooLocalServiceImpl.java").exists());
        Assert.assertTrue((boolean)new File(sbServiceDir, "src/main/java/com/liferay/sampleservicebuilder/service/impl/FooServiceImpl.java").exists());
        Assert.assertTrue((boolean)new File(sbServiceDir, "src/main/java/com/liferay/sampleservicebuilder/model/impl/FooImpl.java").exists());
        File bndBnd = new File(sbApiDir, "bnd.bnd");
        Assert.assertTrue((boolean)bndBnd.exists());
        String bndContent = FileUtil.read((File)bndBnd);
        Assert.assertTrue((String)bndContent, (boolean)bndContent.contains("com.liferay.sampleservicebuilder.exception"));
    }

    @Test
    public void testConvertServiceBuilderTasksPortletCustomName() throws Exception {
        File testdir = new File(this.temporaryFolder.getRoot(), "build/test-tasks-portlet-conversion");
        String[] args = new String[]{"--base", testdir.getPath(), "init", "-u"};
        BladeTest bladeTest = new BladeTest(this.temporaryFolder.getRoot());
        bladeTest.run(args);
        File pluginsSdkDir = new File(testdir, "plugins-sdk");
        FileUtil.copyDir((Path)new File("test-resources/projects/tasks-plugins-sdk").toPath(), (Path)pluginsSdkDir.toPath());
        Assert.assertTrue((boolean)new File(testdir, "plugins-sdk/portlets/tasks-portlet").exists());
        String[] convertArgs = new String[]{"--base", testdir.getPath(), "convert", "tasks-portlet", "foo"};
        bladeTest = new BladeTest(this.temporaryFolder.getRoot());
        bladeTest.run(convertArgs);
        Assert.assertTrue((boolean)new File(testdir, "modules/foo/foo-api/build.gradle").exists());
    }

    @Test
    public void testConvertServiceBuilderTasksPortletDefaultName() throws Exception {
        File testdir = new File(this.temporaryFolder.getRoot(), "build/test-tasks-portlet-conversion");
        String[] args = new String[]{"--base", testdir.getPath(), "init", "-u"};
        BladeTest bladeTest = new BladeTest(this.temporaryFolder.getRoot());
        bladeTest.run(args);
        File pluginsSdkDir = new File(testdir, "plugins-sdk");
        FileUtil.copyDir((Path)new File("test-resources/projects/tasks-plugins-sdk").toPath(), (Path)pluginsSdkDir.toPath());
        Assert.assertTrue((boolean)new File(testdir, "plugins-sdk/portlets/tasks-portlet").exists());
        String[] convertArgs = new String[]{"--base", testdir.getPath(), "convert", "tasks-portlet"};
        bladeTest = new BladeTest(this.temporaryFolder.getRoot());
        bladeTest.run(convertArgs);
        Assert.assertTrue((boolean)new File(testdir, "modules/tasks/tasks-api/build.gradle").exists());
        Assert.assertTrue((boolean)new File(testdir, "modules/tasks/tasks-api/src/main/java/com/liferay/tasks/exception").exists());
        File file = new File(testdir, "modules/tasks/tasks-service/src/main/java/com/liferay/tasks/model/impl/TasksEntryModelImpl.java");
        Assert.assertTrue((boolean)file.exists());
        file = new File(testdir, "modules/tasks/tasks-service/src/main/java/com/liferay/tasks/service/impl/TasksEntryServiceImpl.java");
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)new File(testdir, "modules/tasks/tasks-service/service.xml").exists());
        Assert.assertFalse((boolean)new File(testdir, "wars/tasks-portlet/src/main/webapp/WEB-INF/service.xml").exists());
        Assert.assertTrue((boolean)new File(testdir, "wars/tasks-portlet/src/main/webapp/WEB-INF/portlet.xml").exists());
        File portletGradleFile = new File(testdir, "wars/tasks-portlet/build.gradle");
        Assert.assertTrue((boolean)portletGradleFile.exists());
        String content = new String(Files.readAllBytes(portletGradleFile.toPath()));
        Assert.assertTrue((boolean)content.contains("compileOnly project(\":modules:tasks:tasks-api\")"));
    }
}

