/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeTest;
import com.liferay.blade.cli.TestUtil;
import com.liferay.blade.cli.command.JavaProcess;
import com.liferay.blade.cli.command.JavaProcesses;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.zeroturnaround.process.PidProcess;
import org.zeroturnaround.process.Processes;

public class ServerStartCommandTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File _testWorkspaceDir = null;
    private Predicate<JavaProcess> _tomcatFilter = process -> {
        String displayName = process.getDisplayName();
        return displayName.contains("org.apache.catalina.startup.Bootstrap");
    };
    private Predicate<JavaProcess> _wildflyFilter = process -> {
        String displayName = process.getDisplayName();
        return displayName.contains("jboss-modules");
    };

    @Before
    public void setUp() throws Exception {
        this._testWorkspaceDir = this.temporaryFolder.newFolder("testWorkspaceDir");
        this._killTomcat();
        this._killWildfly();
    }

    @Test
    public void testServerStartCommandExists() throws Exception {
        Assert.assertTrue((boolean)ServerStartCommandTest._commandExists("server", "start"));
        Assert.assertTrue((boolean)ServerStartCommandTest._commandExists("server start"));
        Assert.assertFalse((boolean)ServerStartCommandTest._commandExists("server", "startx"));
        Assert.assertFalse((boolean)ServerStartCommandTest._commandExists("server startx"));
        Assert.assertFalse((boolean)ServerStartCommandTest._commandExists("serverx", "start"));
        Assert.assertFalse((boolean)ServerStartCommandTest._commandExists("serverx start"));
    }

    @Test
    public void testServerStartCommandTomcat() throws Exception {
        String[] initArgs = new String[]{"--base", this._testWorkspaceDir.getPath(), "init", "-v", "7.1"};
        new BladeTest().run(initArgs);
        File gradleProperties = new File(this._testWorkspaceDir, "gradle.properties");
        String contents = new String(Files.readAllBytes(gradleProperties.toPath()));
        StringBuilder sb = new StringBuilder();
        sb.append("liferay.workspace.bundle.url=");
        sb.append("https://releases-cdn.liferay.com/portal/7.1.1-ga2/");
        sb.append("liferay-ce-portal-tomcat-7.1.1-ga2-20181112144637000.tar.gz");
        sb.append(System.lineSeparator());
        String bundleUrl = sb.toString();
        contents = bundleUrl + contents;
        Files.write(gradleProperties.toPath(), bundleUrl.getBytes(), StandardOpenOption.TRUNCATE_EXISTING);
        String[] gwArgs = new String[]{"--base", this._testWorkspaceDir.getPath(), "gw", "initBundle"};
        new BladeTest().run(gwArgs);
        File bundlesFolder = new File(this._testWorkspaceDir, "bundles/tomcat-9.0.10");
        Assert.assertTrue((boolean)bundlesFolder.exists());
        String[] serverStartArgs = new String[]{"--base", this._testWorkspaceDir.getPath(), "server", "start"};
        try {
            new BladeTest().run(serverStartArgs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Thread.sleep(1000L);
        Collection<JavaProcess> javaProcesses = JavaProcesses.list();
        Optional<JavaProcess> tomcatProcess = this._findProcess(javaProcesses, this._tomcatFilter);
        Assert.assertTrue((String)("Expected to find tomcat process:\n" + this._printDisplayNames(javaProcesses)), (boolean)tomcatProcess.isPresent());
        JavaProcess javaProcess = tomcatProcess.get();
        PidProcess tomcatPidProcess = Processes.newPidProcess((int)javaProcess.getId());
        Assert.assertTrue((String)"Expected tomcat process to be alive", (boolean)tomcatPidProcess.isAlive());
        tomcatPidProcess.destroyForcefully();
        tomcatPidProcess.waitFor(1L, TimeUnit.SECONDS);
        Assert.assertFalse((String)"Expected tomcat proces to be destroyed.", (boolean)tomcatPidProcess.isAlive());
    }

    @Test
    public void testServerStartCommandWildfly() throws Exception {
        String[] initArgs = new String[]{"--base", this._testWorkspaceDir.getPath(), "init", "-v", "7.1"};
        new BladeTest().run(initArgs);
        File gradleProperties = new File(this._testWorkspaceDir, "gradle.properties");
        String contents = new String(Files.readAllBytes(gradleProperties.toPath()));
        StringBuilder sb = new StringBuilder();
        sb.append("liferay.workspace.bundle.url=");
        sb.append("https://releases-cdn.liferay.com/portal/7.1.1-ga2/");
        sb.append("liferay-ce-portal-wildfly-7.1.1-ga2-20181112144637000.tar.gz");
        sb.append(System.lineSeparator());
        String bundleUrl = sb.toString();
        contents = bundleUrl + contents;
        Files.write(gradleProperties.toPath(), bundleUrl.getBytes(), StandardOpenOption.TRUNCATE_EXISTING);
        String[] gwArgs = new String[]{"--base", this._testWorkspaceDir.getPath(), "gw", "initBundle"};
        new BladeTest().run(gwArgs);
        File bundlesFolder = new File(this._testWorkspaceDir, "bundles/wildfly-11.0.0");
        Assert.assertTrue((boolean)bundlesFolder.exists());
        String[] serverStartArgs = new String[]{"--base", this._testWorkspaceDir.getPath(), "server", "start"};
        new BladeTest().run(serverStartArgs);
        Thread.sleep(1000L);
        Collection<JavaProcess> javaProcesses = JavaProcesses.list();
        Optional<JavaProcess> wildflyProcess = this._findProcess(javaProcesses, this._wildflyFilter);
        Assert.assertTrue((String)"Expected tomcat process to be started", (boolean)wildflyProcess.isPresent());
        JavaProcess javaProcess = wildflyProcess.get();
        PidProcess wildflyPidProcess = Processes.newPidProcess((int)javaProcess.getId());
        Assert.assertTrue((String)"Expected wildfly process to be alive", (boolean)wildflyPidProcess.isAlive());
        wildflyPidProcess.destroyForcefully();
        wildflyPidProcess.waitFor(1L, TimeUnit.SECONDS);
        Assert.assertFalse((String)"Expected wildfly proces to be destroyed.", (boolean)wildflyPidProcess.isAlive());
    }

    @Test
    public void testServerStopCommandExists() throws Exception {
        Assert.assertTrue((boolean)ServerStartCommandTest._commandExists("server", "stop"));
        Assert.assertTrue((boolean)ServerStartCommandTest._commandExists("server stop"));
        Assert.assertFalse((boolean)ServerStartCommandTest._commandExists("server", "stopx"));
        Assert.assertFalse((boolean)ServerStartCommandTest._commandExists("server stopx"));
        Assert.assertFalse((boolean)ServerStartCommandTest._commandExists("serverx", "stopx"));
        Assert.assertFalse((boolean)ServerStartCommandTest._commandExists("serverx stop"));
    }

    private static boolean _commandExists(String ... args) {
        try {
            TestUtil.runBlade(args);
        }
        catch (Throwable throwable) {
            String message = throwable.getMessage();
            return Objects.nonNull(message) && !message.contains("No such command");
        }
        return false;
    }

    private Optional<JavaProcess> _findProcess(Collection<JavaProcess> javaProcesses, Predicate<JavaProcess> processFilter) {
        Stream<JavaProcess> stream = javaProcesses.stream();
        return stream.filter(processFilter).findFirst();
    }

    private void _killTomcat() throws Exception {
        Collection<JavaProcess> javaProcesses = JavaProcesses.list();
        Optional<JavaProcess> tomcatProcess = this._findProcess(javaProcesses, this._tomcatFilter);
        if (tomcatProcess.isPresent()) {
            JavaProcess javaProcess = tomcatProcess.get();
            PidProcess tomcatPidProcess = Processes.newPidProcess((int)javaProcess.getId());
            Assert.assertTrue((String)"Expected tomcat process to be alive", (boolean)tomcatPidProcess.isAlive());
            tomcatPidProcess.destroyForcefully();
            tomcatPidProcess.waitFor(1L, TimeUnit.SECONDS);
            Assert.assertFalse((String)"Expected tomcat process to be destroyed.", (boolean)tomcatPidProcess.isAlive());
        }
    }

    private void _killWildfly() throws Exception {
        Collection<JavaProcess> javaProcesses = JavaProcesses.list();
        Optional<JavaProcess> wildflyProcess = this._findProcess(javaProcesses, this._wildflyFilter);
        if (wildflyProcess.isPresent()) {
            JavaProcess javaProcess = wildflyProcess.get();
            PidProcess wildflyPidProcess = Processes.newPidProcess((int)javaProcess.getId());
            Assert.assertTrue((String)"Expected wildfly process to be alive", (boolean)wildflyPidProcess.isAlive());
            wildflyPidProcess.destroyForcefully();
            wildflyPidProcess.waitFor(1L, TimeUnit.SECONDS);
            Assert.assertFalse((String)"Expected wildfly proces to be destroyed.", (boolean)wildflyPidProcess.isAlive());
        }
    }

    private String _printDisplayNames(Collection<JavaProcess> javaProcesses) {
        StringBuilder sb = new StringBuilder();
        for (JavaProcess javaProcess : javaProcesses) {
            sb.append(javaProcess.getDisplayName() + System.lineSeparator());
        }
        return sb.toString();
    }
}

