/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeTestResults;
import com.liferay.blade.cli.TestUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class HelpCommandTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testHelpCommand() throws Exception {
        String content = this._runBlade("help");
        Assert.assertTrue((String)content, (boolean)content.contains("Usage:"));
        Assert.assertFalse((String)content, (boolean)content.contains("--"));
    }

    @Test
    public void testHelpCommandSpecific() throws Exception {
        String content = this._runBlade("help", "create");
        Assert.assertTrue((String)content, (boolean)content.contains("Usage:"));
        Assert.assertTrue((String)content, (boolean)content.contains("--"));
    }

    @Test
    public void testHelpFlag() throws Exception {
        String content = this._runBlade("--help");
        Assert.assertTrue((String)content, (boolean)content.contains("Usage:"));
    }

    private String _runBlade(String ... args) throws Exception {
        BladeTestResults bladeTestResults = TestUtil.runBlade(this.temporaryFolder.getRoot(), args);
        String output = bladeTestResults.getOutput();
        Assert.assertFalse((String)output, (boolean)output.contains("No such command"));
        return output;
    }
}

