/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli;

import com.liferay.blade.cli.util.FileUtil;
import com.liferay.blade.cli.util.FileWatcher;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileWatcherTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File _testDir = null;
    private File _testfile = null;
    private File _testsecondfile = null;

    @After
    public void cleanUp() throws Exception {
        if (this._testDir.exists()) {
            FileUtil.deleteDir((Path)this._testDir.toPath());
            Assert.assertFalse((boolean)this._testDir.exists());
        }
    }

    @Before
    public void setUp() throws Exception {
        this._testDir = this.temporaryFolder.newFolder(new String[]{"build", "watch"});
        this._testfile = new File(this._testDir, "file.txt");
        this._testfile.createNewFile();
        this._testsecondfile = new File(this._testDir, "second.txt");
        this._testsecondfile.createNewFile();
    }

    @Ignore
    @Test
    public void testFileWatcherMultipleFiles() throws Exception {
        Files.write(this._testfile.toPath(), "foobar".getBytes(), new OpenOption[0]);
        final HashMap<Path, Boolean> changed = new HashMap<Path, Boolean>();
        changed.put(this._testfile.toPath(), false);
        changed.put(this._testsecondfile.toPath(), false);
        final CountDownLatch latch = new CountDownLatch(2);
        FileWatcher.Consumer<Path> consumer = new FileWatcher.Consumer<Path>(){

            public void consume(Path modified) {
                changed.put(modified, true);
                latch.countDown();
            }
        };
        Thread t = new Thread((FileWatcher.Consumer)consumer){
            final /* synthetic */ FileWatcher.Consumer val$consumer;
            {
                this.val$consumer = consumer;
            }

            @Override
            public void run() {
                try {
                    new FileWatcher(FileWatcherTest.this._testDir.toPath(), false, this.val$consumer);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        t.setDaemon(true);
        t.start();
        Thread.sleep(2000L);
        Files.write(this._testfile.toPath(), "touch".getBytes(), new OpenOption[0]);
        Files.write(this._testsecondfile.toPath(), "second file content".getBytes(), new OpenOption[0]);
        latch.await();
        for (Map.Entry entry : changed.entrySet()) {
            Assert.assertTrue((boolean)((Boolean)entry.getValue()));
        }
    }

    @Ignore
    @Test
    public void testFileWatcherSingleFile() throws Exception {
        final boolean[] changed = new boolean[1];
        final CountDownLatch latch = new CountDownLatch(1);
        FileWatcher.Consumer<Path> consumer = new FileWatcher.Consumer<Path>(){

            public void consume(Path modified) {
                changed[0] = true;
                latch.countDown();
            }
        };
        Assert.assertFalse((boolean)changed[0]);
        Thread t = new Thread((FileWatcher.Consumer)consumer){
            final /* synthetic */ FileWatcher.Consumer val$consumer;
            {
                this.val$consumer = consumer;
            }

            @Override
            public void run() {
                try {
                    new FileWatcher(FileWatcherTest.this._testDir.toPath(), FileWatcherTest.this._testfile.toPath(), false, this.val$consumer);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        t.setDaemon(true);
        t.start();
        Thread.sleep(1000L);
        Files.write(this._testfile.toPath(), "touch".getBytes(), new OpenOption[0]);
        latch.await();
        Assert.assertTrue((boolean)changed[0]);
    }
}

