/*
 * Decompiled with CFR 0.152.
 */
package com.leo618.appupdate;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;
import android.util.Log;
import com.leo618.appupdate.UpdateConfigs;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

public final class UpdateUtil {
    public static String readStream(InputStream is) {
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) != -1) {
                baos.write(buf, 0, len);
            }
            is.close();
            return baos.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void log(String msg) {
        if (!UpdateConfigs.DEBUG) {
            return;
        }
        Log.d((String)"lzj/Update", (String)msg);
    }

    public static int getPackageVersionCode(Context context) {
        if (context == null) {
            return -1;
        }
        int verCode = -1;
        PackageManager pm = context.getPackageManager();
        try {
            PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 0);
            if (null != pi.versionName) {
                verCode = pi.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return verCode;
    }

    public static File getExternalStorageDirectory() {
        if (Environment.getExternalStorageState().equals("mounted")) {
            return Environment.getExternalStorageDirectory();
        }
        return null;
    }

    public static File getAppRootDir(Context context) {
        File externalCacheDir = context.getExternalCacheDir();
        if (null == UpdateUtil.getExternalStorageDirectory() || externalCacheDir == null) {
            return context.getCacheDir();
        }
        File externalAppRootDir = externalCacheDir.getParentFile();
        if (!externalAppRootDir.exists()) {
            externalAppRootDir.mkdirs();
        }
        return externalAppRootDir;
    }

    public static String getAppRootDirPath(Context context) {
        String path = UpdateUtil.getAppRootDir(context).getAbsolutePath();
        if (!TextUtils.isEmpty((CharSequence)path) && !path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        return path;
    }

    public static String getAppName(Context context) {
        PackageManager pm = context.getPackageManager();
        String name = "";
        try {
            name = pm.getApplicationLabel(pm.getApplicationInfo(context.getPackageName(), 128)).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    public static String getDownloadApkFilePath(Context context) {
        return UpdateUtil.getAppRootDirPath(context) + UpdateUtil.getAppName(context) + ".apk";
    }

    public static String md5File(File file) {
        try {
            int len;
            MessageDigest digest = MessageDigest.getInstance("MD5");
            FileInputStream fis = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            while ((len = fis.read(buffer)) != -1) {
                digest.update(buffer, 0, len);
            }
            byte[] result = digest.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : result) {
                String str = Integer.toHexString(b & 0xFF);
                if (str.length() == 1) {
                    sb.append("0");
                }
                sb.append(str);
            }
            fis.close();
            return sb.toString().toUpperCase();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void installApkFile(String apkFilePath) {
        Uri apkUri;
        if (UpdateConfigs.context == null) {
            throw new IllegalArgumentException("\u8bf7\u8bbe\u7f6e\u4e0a\u4e0b\u6587\u53c2\u6570\uff0c\u5efa\u8bae\u4f7f\u7528applicationContext\uff0c \u8c03\u7528UpdateManager.config()\u8bbe\u7f6e");
        }
        UpdateUtil.log("launch install app UI");
        Intent intentForInstall = new Intent();
        intentForInstall.setAction("android.intent.action.VIEW");
        intentForInstall.setFlags(0x10000000);
        File apkFile = new File(apkFilePath);
        if (Build.VERSION.SDK_INT >= 24) {
            apkUri = FileProvider.getUriForFile((Context)UpdateConfigs.context, (String)(UpdateConfigs.context.getPackageName() + ".fileprovider"), (File)apkFile);
            intentForInstall.addFlags(1);
        } else {
            apkUri = Uri.fromFile((File)apkFile);
        }
        intentForInstall.setDataAndType(apkUri, "application/vnd.android.package-archive");
        UpdateConfigs.context.startActivity(intentForInstall);
    }
}

