/*
 * Decompiled with CFR 0.152.
 */
package com.leo618.appupdate;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.text.TextUtils;
import com.leo618.appupdate.UpdateConfigs;
import com.leo618.appupdate.UpdateDataBean;
import com.leo618.appupdate.UpdateDefaultDisplayDialogUI;
import com.leo618.appupdate.UpdateException;
import com.leo618.appupdate.UpdateResultCallback;
import com.leo618.appupdate.UpdateUtil;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONObject;

public class UpdateManager {
    private static final AtomicReference<UpdateManager> INSTANCE = new AtomicReference();
    private Handler uiHandler;
    private static String urlForCheck;
    private static UpdateResultCallback updateResultCallback;
    private static AtomicBoolean mRequesting;

    private static UpdateManager getInstance() {
        UpdateManager manager;
        do {
            if ((manager = INSTANCE.get()) == null) continue;
            return manager;
        } while (!INSTANCE.compareAndSet(null, manager = new UpdateManager()));
        return manager;
    }

    private UpdateManager() {
        if (UpdateConfigs.context == null) {
            throw new IllegalArgumentException("must set UpdateConfigs Context, Application Context is better");
        }
        this.uiHandler = new Handler(Looper.getMainLooper());
    }

    public static void config(Context context, boolean debug, boolean useDefaultDialogDisplay) {
        UpdateConfigs.context = context;
        UpdateConfigs.DEBUG = debug;
        UpdateConfigs.useDefaultDialogDisplay = useDefaultDialogDisplay;
    }

    public static void checkUpdate(String url, UpdateResultCallback callback) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        if (mRequesting.get()) {
            return;
        }
        mRequesting.getAndSet(true);
        urlForCheck = url;
        updateResultCallback = callback;
        UpdateManager.getInstance().checkUpdateInternal();
    }

    private void checkUpdateInternal() {
        if (updateResultCallback != null) {
            updateResultCallback.onStart();
            UpdateUtil.log("onStart.");
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    UpdateManager.this.deleteLocalExpiredFile();
                    URL url = new URL(urlForCheck);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("GET");
                    int code = conn.getResponseCode();
                    if (code == 200) {
                        String result = UpdateUtil.readStream(conn.getInputStream());
                        UpdateUtil.log("result: " + result);
                        if (TextUtils.isEmpty((CharSequence)result)) {
                            UpdateManager.this.sendErrorToUI(new UpdateException("result is null.", 2));
                        } else {
                            JSONObject jsonObject = new JSONObject(result);
                            int status = jsonObject.getInt("status");
                            String msg = jsonObject.getString("msg");
                            if (status != 0) {
                                UpdateManager.this.sendErrorToUI(new UpdateException("server response result status param is not ok. msg:" + msg, 3));
                            } else {
                                PackageInfo packageinfo;
                                int version_id = jsonObject.getInt("version_id");
                                String version_name = jsonObject.getString("version_name");
                                String download_url = jsonObject.getString("download_url");
                                String file_md5 = jsonObject.getString("file_md5");
                                String remark = jsonObject.getString("remark");
                                int is_forced = jsonObject.getInt("is_forced");
                                String apkLocalExistFilePath = null;
                                File apkLocalFile = new File(UpdateUtil.getDownloadApkFilePath(UpdateConfigs.context));
                                if (apkLocalFile.exists() && apkLocalFile.length() > 0L && (packageinfo = UpdateConfigs.context.getPackageManager().getPackageArchiveInfo(apkLocalFile.getAbsolutePath(), 1)) != null && packageinfo.versionCode > UpdateUtil.getPackageVersionCode(UpdateConfigs.context) && packageinfo.versionCode >= version_id) {
                                    apkLocalExistFilePath = apkLocalFile.getAbsolutePath();
                                    version_id = packageinfo.versionCode;
                                }
                                UpdateDataBean data = new UpdateDataBean(version_id, version_name, download_url, file_md5, remark, is_forced, apkLocalExistFilePath);
                                UpdateManager.this.sendSuccessToUI(data);
                                UpdateManager.this.sendShowDialogToUI(data);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    UpdateManager.this.sendErrorToUI(new UpdateException(e.getMessage(), 1));
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private void deleteLocalExpiredFile() {
        PackageInfo packageinfo;
        File apkLocalFile = new File(UpdateUtil.getDownloadApkFilePath(UpdateConfigs.context));
        if (apkLocalFile.exists() && apkLocalFile.length() > 0L && (packageinfo = UpdateConfigs.context.getPackageManager().getPackageArchiveInfo(apkLocalFile.getAbsolutePath(), 1)) != null && packageinfo.versionCode <= UpdateUtil.getPackageVersionCode(UpdateConfigs.context)) {
            apkLocalFile.delete();
        }
    }

    private void sendErrorToUI(final UpdateException exception) {
        this.uiHandler.post(new Runnable(){

            @Override
            public void run() {
                if (updateResultCallback != null) {
                    updateResultCallback.onError(exception);
                }
                UpdateUtil.log("onError. ex:" + (exception == null ? "null" : exception.toString()));
                mRequesting.getAndSet(false);
            }
        });
    }

    private void sendSuccessToUI(final UpdateDataBean data) {
        this.uiHandler.post(new Runnable(){

            @Override
            public void run() {
                if (updateResultCallback != null) {
                    updateResultCallback.onResult(data);
                }
                UpdateUtil.log("onResult. UpdateData: " + data.toString());
                mRequesting.getAndSet(false);
            }
        });
    }

    private void sendShowDialogToUI(final UpdateDataBean data) {
        if (!UpdateConfigs.useDefaultDialogDisplay) {
            return;
        }
        int currVerCode = UpdateUtil.getPackageVersionCode(UpdateConfigs.context);
        if (currVerCode == -1 || currVerCode >= data.getVersion_code()) {
            return;
        }
        this.uiHandler.post(new Runnable(){

            @Override
            public void run() {
                Intent intent = new Intent(UpdateConfigs.context, UpdateDefaultDisplayDialogUI.class);
                intent.addFlags(0x10000000);
                intent.putExtra("data", (Parcelable)data);
                UpdateConfigs.context.startActivity(intent);
                UpdateUtil.log("launch default dialog show update info.");
            }
        });
    }

    static {
        mRequesting = new AtomicBoolean(false);
    }
}

