/*
 * Decompiled with CFR 0.152.
 */
package com.leo618.appupdate;

import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.leo618.appupdate.UpdateConfigs;
import com.leo618.appupdate.UpdateDataBean;
import com.leo618.appupdate.UpdateUtil;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class UpdateDownLoader {
    private DownloadManager mDownloadManager;
    private UpdateDataBean mData;
    private long mIdForDownload = -1L;
    private AtomicBoolean mIsDowning;
    private IDownloadCallback mIDownloadCallback;
    private static final AtomicReference<UpdateDownLoader> INSTANCE = new AtomicReference();
    private static final int WHAT_DOWNLOAD_START = 100;
    private static final int WHAT_DOWNLOAD_ING = 101;
    private static final int WHAT_DOWNLOAD_FINISHED = 102;
    private Timer mTimer;
    private TimerTask mTimerTask;
    private Handler mHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            if (UpdateDownLoader.this.mIDownloadCallback == null) {
                return;
            }
            switch (msg.what) {
                case 100: {
                    UpdateDownLoader.this.mIDownloadCallback.onStart();
                    UpdateUtil.log("download start... url=" + UpdateDownLoader.this.mData.getDownload_url());
                    break;
                }
                case 101: {
                    UpdateDownLoader.this.mIDownloadCallback.onProgress(msg.arg1, msg.arg2);
                    UpdateUtil.log("downloading progress: total=" + msg.arg1 + " , downloaded=" + msg.arg2 + " , " + msg.arg2 * 100 / msg.arg1);
                    break;
                }
                case 102: {
                    UpdateDownLoader.this.mIDownloadCallback.onFinished((File)msg.obj);
                    UpdateUtil.log("download finished apkFile=" + ((File)msg.obj).getAbsolutePath());
                }
            }
        }
    };
    private DownloadReceiver mDownloadReceiver;

    public static UpdateDownLoader getInstance() {
        UpdateDownLoader manager;
        do {
            if ((manager = INSTANCE.get()) == null) continue;
            return manager;
        } while (!INSTANCE.compareAndSet(null, manager = new UpdateDownLoader()));
        return manager;
    }

    private UpdateDownLoader() {
        if (UpdateConfigs.context == null) {
            throw new IllegalArgumentException("\u8bf7\u8bbe\u7f6e\u4e0a\u4e0b\u6587\u53c2\u6570\uff0c\u5efa\u8bae\u4f7f\u7528applicationContext\uff0c \u8c03\u7528UpdateManager.config()\u8bbe\u7f6e");
        }
        this.mDownloadManager = (DownloadManager)UpdateConfigs.context.getSystemService("download");
        this.mIsDowning = new AtomicBoolean(false);
    }

    public void download(UpdateDataBean data) {
        this.mData = data;
        if (this.mData == null) {
            throw new IllegalArgumentException("UpdateDataBean is null.");
        }
        UpdateUtil.log("download : " + this.mData.toString());
        this.registerBroadcastReceiver();
        this.addIntoDowloadTask();
    }

    public void download(UpdateDataBean data, IDownloadCallback callback) {
        this.mIDownloadCallback = callback;
        this.download(data);
    }

    public void cancle() {
        if (this.mIdForDownload == -1L) {
            return;
        }
        this.mDownloadManager.remove(new long[]{this.mIdForDownload});
    }

    public boolean isDownloading() {
        if (this.mIsDowning != null) {
            return this.mIsDowning.get();
        }
        return false;
    }

    public boolean isForceDownloading() {
        if (this.mData != null && this.mData.getIs_forced() == 1 && this.mIsDowning != null) {
            return this.mIsDowning.get();
        }
        return false;
    }

    private void addIntoDowloadTask() {
        final File apkFile = new File(UpdateUtil.getDownloadApkFilePath(UpdateConfigs.context));
        if (apkFile.exists() && apkFile.length() > 0L) {
            apkFile.delete();
        }
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)this.mData.getDownload_url()));
        request.allowScanningByMediaScanner();
        request.setNotificationVisibility(1);
        request.setDestinationUri(Uri.fromFile((File)apkFile));
        request.setTitle((CharSequence)UpdateUtil.getAppName(UpdateConfigs.context));
        request.setMimeType("application/vnd.android.package-archive");
        this.mIdForDownload = this.mDownloadManager.enqueue(request);
        if (this.mIsDowning != null) {
            this.mIsDowning.getAndSet(true);
        }
        UpdateUtil.log("start a request to download apk file. url=" + this.mData.getDownload_url());
        if (this.mIDownloadCallback == null) {
            return;
        }
        Message msg = Message.obtain();
        msg.what = 100;
        this.mHandler.sendMessage(msg);
        final DownloadManager.Query query = new DownloadManager.Query();
        this.mTimer = new Timer();
        this.mTimerTask = new TimerTask(){

            @Override
            public void run() {
                Cursor cursor = UpdateDownLoader.this.mDownloadManager.query(query.setFilterById(new long[]{UpdateDownLoader.this.mIdForDownload}));
                if (cursor != null && cursor.moveToFirst()) {
                    if (cursor.getInt(cursor.getColumnIndex("status")) == 8) {
                        UpdateDownLoader.this.mTimerTask.cancel();
                        UpdateDownLoader.this.mTimer.purge();
                        Message msg = Message.obtain();
                        msg.what = 102;
                        msg.obj = apkFile;
                        UpdateDownLoader.this.mHandler.sendMessage(msg);
                        return;
                    }
                    int downloaded = cursor.getInt(cursor.getColumnIndex("bytes_so_far"));
                    int total = cursor.getInt(cursor.getColumnIndex("total_size"));
                    Message msg = Message.obtain();
                    msg.what = 101;
                    msg.arg1 = total;
                    msg.arg2 = downloaded;
                    UpdateDownLoader.this.mHandler.sendMessage(msg);
                }
                cursor.close();
            }
        };
        this.mTimer.schedule(this.mTimerTask, 0L, 1000L);
    }

    private void registerBroadcastReceiver() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.DOWNLOAD_COMPLETE");
        intentFilter.addAction("android.intent.action.DOWNLOAD_NOTIFICATION_CLICKED");
        if (this.mDownloadReceiver == null) {
            this.mDownloadReceiver = new DownloadReceiver();
        }
        UpdateConfigs.context.registerReceiver((BroadcastReceiver)this.mDownloadReceiver, intentFilter);
        UpdateUtil.log("registerReceiver success.");
    }

    private void unregisterBroadcastReceiver() {
        if (this.mDownloadReceiver != null) {
            UpdateConfigs.context.unregisterReceiver((BroadcastReceiver)this.mDownloadReceiver);
            this.mDownloadReceiver = null;
            UpdateUtil.log("unregisterReceiver success.");
        }
    }

    public static interface IDownloadCallback {
        public void onStart();

        public void onProgress(int var1, int var2);

        public void onFinished(File var1);
    }

    private class DownloadReceiver
    extends BroadcastReceiver {
        private DownloadReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.DOWNLOAD_COMPLETE") || intent.getAction().equals("android.intent.action.DOWNLOAD_NOTIFICATION_CLICKED")) {
                if (UpdateDownLoader.this.mIsDowning != null) {
                    UpdateDownLoader.this.mIsDowning.getAndSet(false);
                }
                if (UpdateDownLoader.this.mData == null) {
                    return;
                }
                UpdateUtil.log("receiver has received, now check md5 is same with server.");
                File downloadedApkFile = new File(UpdateUtil.getDownloadApkFilePath(UpdateConfigs.context));
                String md5Local = UpdateUtil.md5File(downloadedApkFile);
                UpdateUtil.log("downloaded apk file md5 = " + md5Local + " \n server apk file md5 = " + UpdateDownLoader.this.mData.getFile_md5());
                if (!md5Local.equalsIgnoreCase(UpdateDownLoader.this.mData.getFile_md5())) {
                    boolean deleteResult = false;
                    if (downloadedApkFile.exists()) {
                        deleteResult = downloadedApkFile.delete();
                    }
                    UpdateUtil.log("md5 is not fit, delete downloaded apk file = " + deleteResult);
                } else {
                    UpdateUtil.installApkFile(downloadedApkFile.getAbsolutePath());
                }
            }
            UpdateDownLoader.this.unregisterBroadcastReceiver();
        }
    }
}

