/*
 * Decompiled with CFR 0.152.
 */
package com.ledger.lib.utils;

import com.ledger.lib.LedgerException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class VarintUtils {
    public static long read(ByteArrayInputStream in) throws LedgerException {
        long result = 0L;
        int val1 = in.read() & 0xFF;
        if (val1 < 253) {
            result = val1;
        } else if (val1 == 253) {
            result |= (long)(in.read() & 0xFF);
            result |= (long)((in.read() & 0xFF) << 8);
        } else if (val1 == 254) {
            result |= (long)(in.read() & 0xFF);
            result |= (long)((in.read() & 0xFF) << 8);
            result |= (long)((in.read() & 0xFF) << 16);
            result |= (long)((in.read() & 0xFF) << 24);
        } else {
            throw new LedgerException(LedgerException.ExceptionReason.INVALID_PARAMETER, "Unsupported varint encoding");
        }
        return result;
    }

    public static void write(ByteArrayOutputStream buffer, long value) {
        if (value < 253L) {
            buffer.write((byte)value);
        } else if (value <= 65535L) {
            buffer.write(253);
            buffer.write((byte)(value & 0xFFL));
            buffer.write((byte)(value >> 8 & 0xFFL));
        } else {
            buffer.write(254);
            buffer.write((byte)(value & 0xFFL));
            buffer.write((byte)(value >> 8 & 0xFFL));
            buffer.write((byte)(value >> 16 & 0xFFL));
            buffer.write((byte)(value >> 24 & 0xFFL));
        }
    }
}

