/*
 * Decompiled with CFR 0.152.
 */
package com.ledger.lib.utils;

import com.ledger.lib.apps.common.WalletAddress;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class SerializeHelper {
    public static String readString(byte[] buffer, int offset, int length) {
        return StandardCharsets.US_ASCII.decode(ByteBuffer.wrap(Arrays.copyOfRange(buffer, offset, offset + length))).toString();
    }

    public static void writeUint16BE(ByteArrayOutputStream buffer, long value) {
        buffer.write((byte)(value >> 8 & 0xFFL));
        buffer.write((byte)(value & 0xFFL));
    }

    public static long readUint32BE(byte[] buffer, int offset) {
        return (buffer[offset] & 0xFF) << 24 | (buffer[offset + 1] & 0xFF) << 16 | (buffer[offset + 2] & 0xFF) << 8 | buffer[offset + 3] & 0xFF;
    }

    public static long readUint32LE(byte[] buffer, int offset) {
        return (buffer[offset + 3] & 0xFF) << 24 | (buffer[offset + 2] & 0xFF) << 16 | (buffer[offset + 1] & 0xFF) << 8 | buffer[offset] & 0xFF;
    }

    public static void writeUint32BE(ByteArrayOutputStream buffer, long value) {
        buffer.write((byte)(value >> 24 & 0xFFL));
        buffer.write((byte)(value >> 16 & 0xFFL));
        buffer.write((byte)(value >> 8 & 0xFFL));
        buffer.write((byte)(value & 0xFFL));
    }

    public static void writeUint32LE(ByteArrayOutputStream buffer, long value) {
        buffer.write((byte)(value & 0xFFL));
        buffer.write((byte)(value >> 8 & 0xFFL));
        buffer.write((byte)(value >> 16 & 0xFFL));
        buffer.write((byte)(value >> 24 & 0xFFL));
    }

    public static void writeUint64LE(ByteArrayOutputStream buffer, long value) {
        buffer.write((byte)(value & 0xFFL));
        buffer.write((byte)(value >> 8 & 0xFFL));
        buffer.write((byte)(value >> 16 & 0xFFL));
        buffer.write((byte)(value >> 24 & 0xFFL));
        buffer.write((byte)(value >> 32 & 0xFFL));
        buffer.write((byte)(value >> 40 & 0xFFL));
        buffer.write((byte)(value >> 48 & 0xFFL));
        buffer.write((byte)(value >> 56 & 0xFFL));
    }

    public static void writeUint64BE(ByteArrayOutputStream buffer, long value) {
        buffer.write((byte)(value >> 56 & 0xFFL));
        buffer.write((byte)(value >> 48 & 0xFFL));
        buffer.write((byte)(value >> 40 & 0xFFL));
        buffer.write((byte)(value >> 32 & 0xFFL));
        buffer.write((byte)(value >> 24 & 0xFFL));
        buffer.write((byte)(value >> 16 & 0xFFL));
        buffer.write((byte)(value >> 8 & 0xFFL));
        buffer.write((byte)(value & 0xFFL));
    }

    public static void writeBuffer(ByteArrayOutputStream buffer, byte[] value) {
        buffer.write(value, 0, value.length);
    }

    public static byte[] stringToByteArray(String data) {
        return StandardCharsets.US_ASCII.encode(data).array();
    }

    public static WalletAddress readWalletAddress(byte[] buffer) {
        byte[] chainCode = null;
        int offset = 0;
        int publicKeyLength = buffer[offset++] & 0xFF;
        byte[] publicKey = Arrays.copyOfRange(buffer, offset, offset + publicKeyLength);
        offset += publicKeyLength;
        int coinAddressLength = buffer[offset++] & 0xFF;
        String coinAddress = SerializeHelper.readString(buffer, offset, coinAddressLength);
        if ((offset += coinAddressLength) + 32 <= buffer.length) {
            chainCode = Arrays.copyOfRange(buffer, offset, offset + 32);
        }
        return new WalletAddress(publicKey, coinAddress, chainCode);
    }
}

