/*
 * Decompiled with CFR 0.152.
 */
package com.ledger.lib.transport;

import com.ledger.lib.LedgerException;
import java.io.ByteArrayOutputStream;

public class LedgerWrapper {
    private static final int TAG_APDU = 5;

    private static byte[] wrapCommandAPDUInternal(int channel, byte[] command, int packetSize, boolean hasChannel) throws LedgerException {
        int headerSize;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        if (packetSize < 3) {
            throw new LedgerException(LedgerException.ExceptionReason.INVALID_PARAMETER, "Can't handle Ledger framing with less than 3 bytes for the report");
        }
        int sequenceIdx = 0;
        int offset = 0;
        int n = headerSize = hasChannel ? 7 : 5;
        if (hasChannel) {
            output.write(channel >> 8);
            output.write(channel);
        }
        output.write(5);
        output.write(sequenceIdx >> 8);
        output.write(sequenceIdx);
        ++sequenceIdx;
        output.write(command.length >> 8);
        output.write(command.length);
        int blockSize = command.length > packetSize - headerSize ? packetSize - headerSize : command.length;
        output.write(command, offset, blockSize);
        offset += blockSize;
        while (offset != command.length) {
            if (hasChannel) {
                output.write(channel >> 8);
                output.write(channel);
            }
            output.write(5);
            output.write(sequenceIdx >> 8);
            output.write(sequenceIdx);
            ++sequenceIdx;
            blockSize = command.length - offset > packetSize - headerSize + 2 ? packetSize - headerSize + 2 : command.length - offset;
            output.write(command, offset, blockSize);
            offset += blockSize;
        }
        if (output.size() % packetSize != 0) {
            byte[] padding = new byte[packetSize - output.size() % packetSize];
            output.write(padding, 0, padding.length);
        }
        return output.toByteArray();
    }

    private static byte[] unwrapResponseAPDUInternal(int channel, byte[] data, int packetSize, boolean hasChannel) throws LedgerException {
        int headerSize;
        ByteArrayOutputStream response = new ByteArrayOutputStream();
        int offset = 0;
        int sequenceIdx = 0;
        int n = headerSize = hasChannel ? 7 : 5;
        if (data == null || data.length < headerSize) {
            return null;
        }
        if (hasChannel) {
            if (data[offset++] != channel >> 8) {
                throw new LedgerException(LedgerException.ExceptionReason.IO_ERROR, "Invalid channel");
            }
            if (data[offset++] != (channel & 0xFF)) {
                throw new LedgerException(LedgerException.ExceptionReason.IO_ERROR, "Invalid channel");
            }
        }
        if (data[offset++] != 5) {
            throw new LedgerException(LedgerException.ExceptionReason.IO_ERROR, "Invalid tag");
        }
        if (data[offset++] != 0) {
            throw new LedgerException(LedgerException.ExceptionReason.IO_ERROR, "Invalid sequence");
        }
        if (data[offset++] != 0) {
            throw new LedgerException(LedgerException.ExceptionReason.IO_ERROR, "Invalid sequence");
        }
        int responseLength = (data[offset++] & 0xFF) << 8;
        if (data.length < headerSize + (responseLength |= data[offset++] & 0xFF)) {
            return null;
        }
        int blockSize = responseLength > packetSize - headerSize ? packetSize - headerSize : responseLength;
        response.write(data, offset, blockSize);
        offset += blockSize;
        while (response.size() != responseLength) {
            ++sequenceIdx;
            if (offset == data.length) {
                return null;
            }
            if (hasChannel) {
                if (data[offset++] != channel >> 8) {
                    throw new LedgerException(LedgerException.ExceptionReason.IO_ERROR, "Invalid channel");
                }
                if (data[offset++] != (channel & 0xFF)) {
                    throw new LedgerException(LedgerException.ExceptionReason.IO_ERROR, "Invalid channel");
                }
            }
            if (data[offset++] != 5) {
                throw new LedgerException(LedgerException.ExceptionReason.IO_ERROR, "Invalid tag");
            }
            if (data[offset++] != sequenceIdx >> 8) {
                throw new LedgerException(LedgerException.ExceptionReason.IO_ERROR, "Invalid sequence");
            }
            if (data[offset++] != (sequenceIdx & 0xFF)) {
                throw new LedgerException(LedgerException.ExceptionReason.IO_ERROR, "Invalid sequence");
            }
            int n2 = blockSize = responseLength - response.size() > packetSize - headerSize + 2 ? packetSize - headerSize + 2 : responseLength - response.size();
            if (blockSize > data.length - offset) {
                return null;
            }
            response.write(data, offset, blockSize);
            offset += blockSize;
        }
        return response.toByteArray();
    }

    public static byte[] wrapCommandAPDU(int channel, byte[] command, int packetSize) throws LedgerException {
        return LedgerWrapper.wrapCommandAPDUInternal(channel, command, packetSize, true);
    }

    public static byte[] wrapCommandAPDU(byte[] command, int packetSize) throws LedgerException {
        return LedgerWrapper.wrapCommandAPDUInternal(0, command, packetSize, false);
    }

    public static byte[] unwrapResponseAPDU(int channel, byte[] data, int packetSize) throws LedgerException {
        return LedgerWrapper.unwrapResponseAPDUInternal(channel, data, packetSize, true);
    }

    public static byte[] unwrapResponseAPDU(byte[] data, int packetSize) throws LedgerException {
        return LedgerWrapper.unwrapResponseAPDUInternal(0, data, packetSize, false);
    }
}

