/*
 * Decompiled with CFR 0.152.
 */
package com.ledger.lib.apps.trx;

import android.content.Context;
import com.ledger.lib.LedgerException;
import com.ledger.lib.R;
import com.ledger.lib.utils.SerializeHelper;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

public class TrxCache {
    private static HashMap<Long, byte[]> cacheTrc10 = new HashMap();
    private static HashMap<Long, byte[]> cacheExchanges = new HashMap();

    public static boolean isProvisioned() {
        return cacheTrc10.size() != 0;
    }

    private static void loadCache(HashMap<Long, byte[]> cache, byte[] blob) throws LedgerException {
        int itemSize;
        cache.clear();
        for (int offset = 0; offset != blob.length; offset += 8 + itemSize) {
            long id = SerializeHelper.readUint32BE(blob, offset);
            itemSize = (int)SerializeHelper.readUint32BE(blob, offset + 4);
            cache.put(id, Arrays.copyOfRange(blob, offset + 4 + 4, offset + 4 + 4 + itemSize));
        }
    }

    public static void loadTrc10Cache(byte[] blob) throws LedgerException {
        TrxCache.loadCache(cacheTrc10, blob);
    }

    public static void loadExchangesCache(byte[] blob) throws LedgerException {
        TrxCache.loadCache(cacheExchanges, blob);
    }

    private static byte[] readResource(Context context, int id) {
        try {
            int dataRead;
            BufferedInputStream is = new BufferedInputStream(context.getResources().openRawResource(id));
            byte[] data = new byte[is.available()];
            for (int offset = 0; offset != data.length; offset += dataRead) {
                dataRead = is.read(data, offset, data.length - offset);
            }
            return data;
        }
        catch (IOException e) {
            throw new LedgerException(LedgerException.ExceptionReason.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public static void loadCacheInternal(Context context) throws LedgerException {
        TrxCache.loadTrc10Cache(TrxCache.readResource(context, R.raw.trc10));
        TrxCache.loadExchangesCache(TrxCache.readResource(context, R.raw.tronexchanges));
    }

    public static byte[] lookupTrc10(Long id) {
        return cacheTrc10.get(id);
    }

    public static byte[] lookupExchange(Long id) {
        return cacheExchanges.get(id);
    }
}

