/*
 * Decompiled with CFR 0.152.
 */
package com.ledger.lib.apps.eth;

import android.content.Context;
import com.ledger.lib.LedgerException;
import com.ledger.lib.R;
import com.ledger.lib.utils.Dump;
import com.ledger.lib.utils.SerializeHelper;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

public class Erc20Cache {
    private static HashMap<String, byte[]> cache = new HashMap();

    public static boolean isProvisioned() {
        return cache.size() != 0;
    }

    public static void loadCache(byte[] blob) throws LedgerException {
        int offset = 0;
        cache.clear();
        while (offset != blob.length) {
            int itemSize = (int)SerializeHelper.readUint32BE(blob, offset);
            int nextOffset = (offset += 4) + itemSize;
            byte[] item = Arrays.copyOfRange(blob, offset, offset + itemSize);
            int tickerLength = blob[offset++] & 0xFF;
            String contractAddress = Dump.dump(blob, offset += tickerLength, 20).toLowerCase();
            cache.put(contractAddress, item);
            offset = nextOffset;
        }
    }

    public static void loadCacheInternal(Context context) throws LedgerException {
        try {
            int dataRead;
            BufferedInputStream is = new BufferedInputStream(context.getResources().openRawResource(R.raw.erc20));
            byte[] data = new byte[is.available()];
            for (int offset = 0; offset != data.length; offset += dataRead) {
                dataRead = is.read(data, offset, data.length - offset);
            }
            Erc20Cache.loadCache(data);
        }
        catch (IOException e) {
            throw new LedgerException(LedgerException.ExceptionReason.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public static byte[] lookup(String address) {
        if ((address = address.toLowerCase()).startsWith("0x")) {
            address = address.substring(2);
        }
        return cache.get(address);
    }
}

