/*
 * Decompiled with CFR 0.152.
 */
package com.ledger.lib.apps.common;

import com.ledger.lib.utils.Dump;
import java.util.Arrays;

public class ECDSADeviceSignature {
    private int v;
    private byte[] r;
    private byte[] s;

    public ECDSADeviceSignature(int v, byte[] r, byte[] s) {
        this.v = v;
        this.r = r;
        this.s = s;
    }

    public ECDSADeviceSignature(int v, byte[] derSignature) {
        this.v = v;
        int offset = 4;
        this.r = Arrays.copyOfRange(derSignature, offset, offset + derSignature[offset - 1]);
        if (this.r[0] == 0) {
            this.r = Arrays.copyOfRange(this.r, 1, this.r.length);
        }
        offset += derSignature[offset - 1] + 2;
        this.s = Arrays.copyOfRange(derSignature, offset, offset + derSignature[offset - 1]);
        if (this.s[0] == 0) {
            this.s = Arrays.copyOfRange(this.s, 1, this.s.length);
        }
    }

    public int getRecoveryInformation() {
        return this.v;
    }

    public byte[] getR() {
        return this.r;
    }

    public byte[] getS() {
        return this.s;
    }

    public byte[] getDER() {
        return null;
    }

    public String toString() {
        return "r " + Dump.dump(this.r) + " s " + Dump.dump(this.s) + " v " + this.v;
    }
}

