/*
 * Decompiled with CFR 0.152.
 */
package com.ledger.lib.apps.btc;

import com.ledger.lib.LedgerException;
import com.ledger.lib.apps.LedgerApplication;
import com.ledger.lib.apps.btc.BtcTransaction;
import com.ledger.lib.apps.common.ECDSADeviceSignature;
import com.ledger.lib.apps.common.WalletAddress;
import com.ledger.lib.transport.LedgerDevice;
import com.ledger.lib.utils.ApduExchange;
import com.ledger.lib.utils.BIP32Helper;
import com.ledger.lib.utils.Dump;
import com.ledger.lib.utils.RIPEMD160Digest;
import com.ledger.lib.utils.SerializeHelper;
import com.ledger.lib.utils.VarintUtils;
import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class Btc
extends LedgerApplication {
    private static final int BTC_CLA = 224;
    private static final int INS_GET_WALLET_PUBLIC_KEY = 64;
    private static final int INS_GET_TRUSTED_INPUT = 66;
    private static final int INS_HASH_INPUT_START = 68;
    private static final int INS_HASH_INPUT_FINALIZE_FULL = 74;
    private static final int INS_HASH_SIGN = 72;
    private static final int INS_SIGN_MESSAGE = 78;
    private static final int P1_NO_DISPLAY = 0;
    private static final int P1_DISPLAY = 1;
    private static final int P2_LEGACY_ADDRESS = 0;
    private static final int P2_SEGWIT = 1;
    private static final int P2_SEGWIT_NATIVE = 2;
    private static final int P1_FIRST_BLOCK = 0;
    private static final int P1_NEXT_BLOCK = 128;
    private static final int P2_NEW_TX = 0;
    private static final int P2_NEW_TX_SEGWIT = 2;
    private static final int P2_CONTINUE_TX = 128;
    private static final int P2_CONTINUE_TX_SEGWIT = 16;
    private static final int P1_MORE_OUTPUT = 0;
    private static final int P1_LAST_OUTPUT = 128;
    private static final int P1_CHANGE_OUTPUT = 255;
    private static final int P1_SIGN_MESSAGE_PREPARE = 0;
    private static final int P1_SIGN_MESSAGE_SIGN = 128;
    private static final int P2_SIGN_MESSAGE_PREPARE_FIRST = 1;
    private static final int P2_SIGN_MESSAGE_PREPARE_NEXT = 128;
    private static final int TAG_INPUT_TRUSTED = 1;
    private static final int TAG_INPUT_WITNESS = 2;
    private static final int SIGHASH_ALL = 1;
    private static final int MAX_BLOCK_SIZE = 255;
    private static final byte[] NULL_SCRIPT = new byte[0];
    private static final byte OP_DUP = 118;
    private static final byte OP_HASH160 = -87;
    private static final byte HASH160_SIZE = 20;
    private static final byte OP_EQUALVERIFY = -120;
    private static final byte OP_CHECKSIG = -84;
    private MessageDigest sha256;
    private RIPEMD160Digest ripemd160;

    public Btc(LedgerDevice device) {
        super(device);
        try {
            this.sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        this.ripemd160 = new RIPEMD160Digest();
    }

    private ApduExchange.ApduResponse exchangeApduSplit(LedgerDevice device, int cla, int ins, int p1, int p2, byte[] data) throws LedgerException {
        int blockSize;
        ApduExchange.ApduResponse response = null;
        for (int offset = 0; offset != data.length; offset += blockSize) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            blockSize = offset + 255 > data.length ? data.length - offset : 255;
            out.write(Arrays.copyOfRange(data, offset, offset + blockSize), 0, blockSize);
            response = ApduExchange.exchangeApdu(device, cla, ins, p1, p2, out.toByteArray());
            response.checkSW();
        }
        return response;
    }

    private ApduExchange.ApduResponse exchangeApduSplit(LedgerDevice device, int cla, int ins, int p1, int p2, byte[] data, byte[] data2) throws LedgerException {
        int blockSize;
        int maxBlockSize = 255 - data2.length;
        ApduExchange.ApduResponse response = null;
        for (int offset = 0; offset != data.length; offset += blockSize) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            blockSize = offset + maxBlockSize > data.length ? data.length - offset : maxBlockSize;
            out.write(Arrays.copyOfRange(data, offset, offset + blockSize), 0, blockSize);
            if (offset + blockSize == data.length) {
                out.write(data2, 0, data2.length);
            }
            response = ApduExchange.exchangeApdu(device, cla, ins, p1, p2, out.toByteArray());
            response.checkSW();
        }
        if (data.length == 0) {
            response = ApduExchange.exchangeApdu(device, cla, ins, p1, p2, data2);
            response.checkSW();
        }
        return response;
    }

    private TXInput getTrustedInput(BtcTransaction transaction, long index) throws LedgerException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        SerializeHelper.writeUint32BE(data, index);
        SerializeHelper.writeBuffer(data, transaction.getVersion());
        VarintUtils.write(data, transaction.getInputs().size());
        ApduExchange.ApduResponse response = ApduExchange.exchangeApdu(this.device, 224, 66, 0, 0, data.toByteArray());
        response.checkSW();
        for (BtcTransaction.BtcInput input : transaction.getInputs()) {
            data = new ByteArrayOutputStream();
            SerializeHelper.writeBuffer(data, input.getPrevHash());
            SerializeHelper.writeUint32LE(data, input.getPrevIndex());
            VarintUtils.write(data, input.getScript().length);
            response = ApduExchange.exchangeApdu(this.device, 224, 66, 128, 0, data.toByteArray());
            response.checkSW();
            data = new ByteArrayOutputStream();
            SerializeHelper.writeBuffer(data, input.getScript());
            this.exchangeApduSplit(this.device, 224, 66, 128, 0, data.toByteArray(), input.getSequence());
        }
        data = new ByteArrayOutputStream();
        VarintUtils.write(data, transaction.getOutputs().size());
        response = ApduExchange.exchangeApdu(this.device, 224, 66, 128, 0, data.toByteArray());
        response.checkSW();
        for (BtcTransaction.BtcOutput output : transaction.getOutputs()) {
            data = new ByteArrayOutputStream();
            SerializeHelper.writeBuffer(data, output.getAmount());
            VarintUtils.write(data, output.getScript().length);
            response = ApduExchange.exchangeApdu(this.device, 224, 66, 128, 0, data.toByteArray());
            response.checkSW();
            data = new ByteArrayOutputStream();
            SerializeHelper.writeBuffer(data, output.getScript());
            response = this.exchangeApduSplit(this.device, 224, 66, 128, 0, data.toByteArray());
            response.checkSW();
        }
        response = ApduExchange.exchangeApdu(this.device, 224, 66, 128, 0, transaction.getLockTime());
        response.checkSW();
        return new TXInput(InputType.INPUT_TRUSTED, Arrays.copyOfRange(response.getResponse(), 0, response.getResponse().length - 2));
    }

    private byte[] getTXHash(BtcTransaction transaction) throws LedgerException {
        byte[] serializedTx = transaction.serialize(false, true);
        byte[] digest = this.sha256.digest(serializedTx);
        digest = this.sha256.digest(digest);
        return digest;
    }

    private AddressFormat scanOutputScriptFormat(byte[] outputScript) {
        if (outputScript.length < 3) {
            return null;
        }
        if (outputScript.length == 25 && outputScript[0] == 118 && outputScript[1] == -87) {
            return AddressFormat.LEGACY;
        }
        if (outputScript.length == 23 && outputScript[0] == -87) {
            return AddressFormat.P2SH;
        }
        if (outputScript.length == 22 && outputScript[0] == 0 && outputScript[1] == 20) {
            return AddressFormat.BECH32;
        }
        return null;
    }

    private TXInput getTrustedInputBIP143(BtcTransaction transaction, byte[] txHash, long index) throws LedgerException {
        if (this.sha256 == null) {
            throw new LedgerException(LedgerException.ExceptionReason.INTERNAL_ERROR, "SHA-256 not available");
        }
        if (index < 0L || index >= (long)transaction.getOutputs().size()) {
            throw new LedgerException(LedgerException.ExceptionReason.INVALID_PARAMETER, "Invalid output reference");
        }
        ByteArrayOutputStream data = new ByteArrayOutputStream(44);
        if (txHash == null) {
            txHash = this.getTXHash(transaction);
        }
        SerializeHelper.writeBuffer(data, txHash);
        SerializeHelper.writeUint32BE(data, index);
        data.write(transaction.getOutputs().get((int)index).getAmount(), 0, 8);
        return new TXInput(InputType.INPUT_WITNESS, data.toByteArray());
    }

    private TXInput getTrustedInputBIP143(BtcTransaction transaction, long index) throws LedgerException {
        return this.getTrustedInputBIP143(transaction, null, index);
    }

    private TXInput getTrustedInputBIP143(TXInput input) throws LedgerException {
        if (input.getInputType() == InputType.INPUT_WITNESS) {
            return input;
        }
        return new TXInput(InputType.INPUT_WITNESS, Arrays.copyOfRange(input.getValue(), 4, 48));
    }

    private byte[] compressPublicKey(byte[] publicKey) throws LedgerException {
        if (publicKey.length == 33) {
            return publicKey;
        }
        if (publicKey.length != 65 || publicKey[0] != 4) {
            throw new LedgerException(LedgerException.ExceptionReason.INVALID_PARAMETER, "Unsupported public key format " + Dump.dump(publicKey));
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(33);
        if ((publicKey[64] & 1) != 0) {
            out.write(3);
        } else {
            out.write(2);
        }
        out.write(publicKey, 1, 32);
        return out.toByteArray();
    }

    private byte[] hashPublicKey(byte[] publicKey) throws LedgerException {
        byte[] hash160 = new byte[20];
        byte[] hashedPublicKey = this.sha256.digest(publicKey);
        this.ripemd160.update(hashedPublicKey, 0, hashedPublicKey.length);
        this.ripemd160.doFinal(hash160, 0);
        return hash160;
    }

    private byte[] getRedeemScriptBIP143(byte[] publicKey) throws LedgerException {
        ByteArrayOutputStream redeemScript = new ByteArrayOutputStream(25);
        byte[] hash160 = this.hashPublicKey(publicKey);
        redeemScript.write(118);
        redeemScript.write(-87);
        redeemScript.write(20);
        SerializeHelper.writeBuffer(redeemScript, hash160);
        redeemScript.write(-120);
        redeemScript.write(-84);
        return redeemScript.toByteArray();
    }

    private byte[] getRedeemScript(BtcTransaction.BtcInput input, AddressFormat addressFormat, BtcTransaction parentTransaction, byte[] associatedPublicKey) throws LedgerException {
        byte[] redeemScript = input.getScript();
        if (redeemScript != null && redeemScript.length != 0) {
            return redeemScript;
        }
        switch (addressFormat) {
            case LEGACY: {
                redeemScript = parentTransaction.getOutputs().get((int)input.getPrevIndex()).getScript();
                break;
            }
            case P2SH: 
            case BECH32: {
                redeemScript = this.getRedeemScriptBIP143(associatedPublicKey);
            }
        }
        return redeemScript;
    }

    private byte[] getRedeemScript(BtcTransaction.BtcInput input, BtcTransaction parentTransaction) throws LedgerException {
        return this.getRedeemScript(input, AddressFormat.LEGACY, parentTransaction, null);
    }

    private byte[] getRedeemScript(BtcTransaction.BtcInput input, AddressFormat addressFormat, byte[] publicKey) {
        return this.getRedeemScript(input, addressFormat, null, publicKey);
    }

    private void startUntrustedTransaction(BtcTransaction transaction, boolean newTransaction, boolean continueSegwit, long inputIndex, TXInput[] usedInputList, byte[] redeemScript) throws LedgerException {
        if (usedInputList.length != transaction.getInputs().size()) {
            throw new LedgerException(LedgerException.ExceptionReason.INVALID_PARAMETER, "Invalid number of inputs passed");
        }
        boolean segwit = false;
        for (TXInput currentInput : usedInputList) {
            if (currentInput.getInputType() != InputType.INPUT_WITNESS) continue;
            segwit = true;
            break;
        }
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        SerializeHelper.writeBuffer(data, transaction.getVersion());
        VarintUtils.write(data, transaction.getInputs().size());
        int p2 = newTransaction ? (segwit ? 2 : 0) : (continueSegwit ? 16 : 128);
        ApduExchange.ApduResponse response = ApduExchange.exchangeApdu(this.device, 224, 68, 0, p2, data.toByteArray());
        response.checkSW();
        long currentIndex = 0L;
        for (BtcTransaction.BtcInput currentInput : transaction.getInputs()) {
            TXInput deviceInput = usedInputList[(int)currentIndex];
            byte[] script = currentIndex == inputIndex ? redeemScript : NULL_SCRIPT;
            data = new ByteArrayOutputStream();
            switch (deviceInput.getInputType()) {
                case INPUT_TRUSTED: {
                    data.write(1);
                    data.write(deviceInput.getValue().length);
                    break;
                }
                case INPUT_WITNESS: {
                    data.write(2);
                }
            }
            SerializeHelper.writeBuffer(data, deviceInput.getValue());
            VarintUtils.write(data, script.length);
            response = ApduExchange.exchangeApdu(this.device, 224, 68, 128, 0, data.toByteArray());
            response.checkSW();
            data = new ByteArrayOutputStream();
            SerializeHelper.writeBuffer(data, script);
            SerializeHelper.writeBuffer(data, currentInput.getSequence());
            response = this.exchangeApduSplit(this.device, 224, 68, 128, 0, data.toByteArray());
            response.checkSW();
            ++currentIndex;
        }
    }

    private void provideOutputFullChangePath(String bip32Path) throws LedgerException {
        byte[] convertedPath = BIP32Helper.splitPath(bip32Path);
        ApduExchange.ApduResponse response = ApduExchange.exchangeApdu(this.device, 224, 74, 255, 0, convertedPath);
        response.checkSW();
    }

    private void hashOutputFull(byte[] output) throws LedgerException {
        int blockSize;
        ApduExchange.ApduResponse response = null;
        for (int offset = 0; offset != output.length; offset += blockSize) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            blockSize = offset + 255 > output.length ? output.length - offset : 255;
            out.write(Arrays.copyOfRange(output, offset, offset + blockSize), 0, blockSize);
            response = ApduExchange.exchangeApdu(this.device, 224, 74, offset + blockSize == output.length ? 128 : 0, 0, out.toByteArray());
            response.checkSW();
        }
    }

    private byte[] signTransaction(BtcTransaction transaction, String bip32Path) throws LedgerException {
        byte[] convertedPath = BIP32Helper.splitPath(bip32Path);
        ApduExchange.ApduResponse response = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SerializeHelper.writeBuffer(out, convertedPath);
        out.write(0);
        SerializeHelper.writeBuffer(out, transaction.getLockTime());
        out.write(1);
        response = ApduExchange.exchangeApdu(this.device, 224, 72, 0, 0, out.toByteArray());
        response.checkSW();
        return Arrays.copyOfRange(response.getResponse(), 0, response.getResponse().length - 2);
    }

    public WalletAddress getWalletAddress(String bip32Path, boolean verify, AddressFormat format) throws LedgerException {
        byte[] convertedPath = BIP32Helper.splitPath(bip32Path);
        int p2 = 0;
        switch (format) {
            case LEGACY: {
                p2 = 0;
                break;
            }
            case P2SH: {
                p2 = 1;
                break;
            }
            case BECH32: {
                p2 = 2;
            }
        }
        ApduExchange.ApduResponse response = ApduExchange.exchangeApdu(this.device, 224, 64, verify ? 1 : 0, p2, convertedPath);
        response.checkSW();
        return SerializeHelper.readWalletAddress(response.getResponse());
    }

    public BtcTransaction signP2PKHTransaction(BtcTransaction unsignedTransaction, List<BtcTransaction> parentTransactions, List<String> associatedKeysets, String changePath) throws LedgerException {
        BtcTransaction previousTx;
        Vector<AddressFormat> outputType = new Vector<AddressFormat>(unsignedTransaction.getInputs().size());
        HashMap<String, BtcTransaction> txs = new HashMap<String, BtcTransaction>(parentTransactions.size());
        HashMap<String, byte[]> publicKeys = new HashMap<String, byte[]>(associatedKeysets.size());
        byte[][] signatures = new byte[associatedKeysets.size()][];
        TXInput[] txInputs = new TXInput[associatedKeysets.size()];
        byte[] serializedOutputs = unsignedTransaction.serializeOutputs();
        boolean segwitInputFound = false;
        boolean legacyInputFound = false;
        boolean newTx = true;
        boolean changeProvided = false;
        ByteArrayOutputStream witness = new ByteArrayOutputStream();
        if (associatedKeysets.size() != unsignedTransaction.getInputs().size()) {
            throw new LedgerException(LedgerException.ExceptionReason.INVALID_PARAMETER, "Number of inputs to sign and provided key paths not matching");
        }
        for (BtcTransaction btcTransaction : parentTransactions) {
            txs.put(Dump.dump(this.getTXHash(btcTransaction)), btcTransaction);
        }
        for (BtcTransaction.BtcInput btcInput : unsignedTransaction.getInputs()) {
            previousTx = (BtcTransaction)txs.get(Dump.dump(btcInput.getPrevHash()));
            if (previousTx == null) {
                throw new LedgerException(LedgerException.ExceptionReason.INVALID_PARAMETER, "Missing input " + Dump.dump(btcInput.getPrevHash()));
            }
            if (btcInput.getPrevIndex() > (long)previousTx.getOutputs().size()) {
                throw new LedgerException(LedgerException.ExceptionReason.INVALID_PARAMETER, "Missing input " + Dump.dump(btcInput.getPrevHash()) + ":" + btcInput.getPrevIndex());
            }
            BtcTransaction.BtcOutput previousOutput = previousTx.getOutputs().get((int)btcInput.getPrevIndex());
            AddressFormat previousOutputFormat = this.scanOutputScriptFormat(previousOutput.getScript());
            if (previousOutputFormat == null) {
                throw new LedgerException(LedgerException.ExceptionReason.INVALID_PARAMETER, "Unrecognized script format for " + Dump.dump(btcInput.getPrevHash()) + ":" + btcInput.getPrevIndex());
            }
            switch (previousOutputFormat) {
                case LEGACY: {
                    legacyInputFound = true;
                    break;
                }
                case P2SH: 
                case BECH32: {
                    segwitInputFound = true;
                }
            }
            outputType.add(previousOutputFormat);
        }
        for (String string : associatedKeysets) {
            if (publicKeys.containsKey(string)) continue;
            WalletAddress walletAddress = this.getWalletAddress(string, false, AddressFormat.LEGACY);
            publicKeys.put(string, this.compressPublicKey(walletAddress.getPublicKey()));
        }
        int index = 0;
        for (BtcTransaction.BtcInput btcInput : unsignedTransaction.getInputs()) {
            previousTx = (BtcTransaction)txs.get(Dump.dump(btcInput.getPrevHash()));
            TXInput trustedInput = legacyInputFound ? this.getTrustedInput(previousTx, btcInput.getPrevIndex()) : this.getTrustedInputBIP143(previousTx, btcInput.getPrevIndex());
            txInputs[index] = trustedInput;
            ++index;
        }
        if (legacyInputFound) {
            index = 0;
            for (BtcTransaction.BtcInput btcInput : unsignedTransaction.getInputs()) {
                if (((AddressFormat)((Object)outputType.get(index))).equals((Object)AddressFormat.LEGACY)) {
                    byte[] redeemScript = this.getRedeemScript(btcInput, (BtcTransaction)txs.get(Dump.dump(btcInput.getPrevHash())));
                    this.startUntrustedTransaction(unsignedTransaction, newTx, false, index, txInputs, redeemScript);
                    newTx = false;
                    if (!changeProvided && changePath != null && changePath.length() != 0) {
                        this.provideOutputFullChangePath(changePath);
                        changeProvided = true;
                    }
                    this.hashOutputFull(serializedOutputs);
                    signatures[index] = this.signTransaction(unsignedTransaction, associatedKeysets.get(index));
                }
                ++index;
            }
        }
        if (segwitInputFound) {
            if (legacyInputFound) {
                for (int i = 0; i < txInputs.length; ++i) {
                    txInputs[i] = this.getTrustedInputBIP143(txInputs[i]);
                }
            }
            TXInput[] txInput = new TXInput[1];
            this.startUntrustedTransaction(unsignedTransaction, newTx, legacyInputFound, 0L, txInputs, NULL_SCRIPT);
            newTx = false;
            if (!changeProvided && changePath != null && changePath.length() != 0) {
                this.provideOutputFullChangePath(changePath);
                changeProvided = true;
            }
            this.hashOutputFull(serializedOutputs);
            index = 0;
            for (BtcTransaction.BtcInput input : unsignedTransaction.getInputs()) {
                if (((AddressFormat)((Object)outputType.get(index))).equals((Object)AddressFormat.P2SH) || ((AddressFormat)((Object)outputType.get(index))).equals((Object)AddressFormat.BECH32)) {
                    BtcTransaction tx = new BtcTransaction();
                    tx.addInput(input);
                    tx.setVersion(unsignedTransaction.getVersion());
                    tx.setLockTime(unsignedTransaction.getLockTime());
                    txInput[0] = txInputs[index];
                    byte[] redeemScript = this.getRedeemScript(input, (AddressFormat)((Object)outputType.get(index)), (byte[])publicKeys.get(associatedKeysets.get(index)));
                    this.startUntrustedTransaction(tx, false, false, 0L, txInput, redeemScript);
                    signatures[index] = this.signTransaction(unsignedTransaction, associatedKeysets.get(index));
                }
                ++index;
            }
        }
        index = 0;
        for (BtcTransaction.BtcInput btcInput : unsignedTransaction.getInputs()) {
            ByteArrayOutputStream scriptSig = new ByteArrayOutputStream();
            ByteArrayOutputStream localWitness = new ByteArrayOutputStream();
            byte[] publicKey = (byte[])publicKeys.get(associatedKeysets.get(index));
            switch ((AddressFormat)((Object)outputType.get(index))) {
                case LEGACY: {
                    scriptSig.write(signatures[index].length);
                    SerializeHelper.writeBuffer(scriptSig, signatures[index]);
                    scriptSig.write(publicKey.length);
                    SerializeHelper.writeBuffer(scriptSig, publicKey);
                    break;
                }
                case P2SH: {
                    scriptSig.write(22);
                    scriptSig.write(0);
                    scriptSig.write(20);
                    SerializeHelper.writeBuffer(scriptSig, this.hashPublicKey(publicKey));
                    break;
                }
            }
            switch ((AddressFormat)((Object)outputType.get(index))) {
                case LEGACY: {
                    if (!segwitInputFound) break;
                    localWitness.write(0);
                    break;
                }
                case P2SH: 
                case BECH32: {
                    localWitness.write(2);
                    localWitness.write(signatures[index].length);
                    SerializeHelper.writeBuffer(localWitness, signatures[index]);
                    localWitness.write(publicKey.length);
                    SerializeHelper.writeBuffer(localWitness, publicKey);
                }
            }
            btcInput.setScript(scriptSig.toByteArray());
            if (segwitInputFound) {
                SerializeHelper.writeBuffer(witness, localWitness.toByteArray());
            }
            ++index;
        }
        if (segwitInputFound) {
            unsignedTransaction.setWitness(witness.toByteArray());
        }
        return unsignedTransaction;
    }

    public ECDSADeviceSignature signMessage(String bip32Path, byte[] message) throws LedgerException {
        int blockSize;
        byte[] convertedPath = BIP32Helper.splitPath(bip32Path);
        ApduExchange.ApduResponse response = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int offset = 0; offset != message.length; offset += blockSize) {
            int maxBlockSize;
            out = new ByteArrayOutputStream();
            if (offset == 0) {
                SerializeHelper.writeBuffer(out, convertedPath);
                SerializeHelper.writeUint16BE(out, message.length);
            }
            blockSize = offset + (maxBlockSize = 255 - out.size()) > message.length ? message.length - offset : maxBlockSize;
            out.write(Arrays.copyOfRange(message, offset, offset + blockSize), 0, blockSize);
            response = ApduExchange.exchangeApdu(this.device, 224, 78, 0, offset == 0 ? 1 : 128, out.toByteArray());
            response.checkSW();
        }
        out = new ByteArrayOutputStream();
        out.write(0);
        response = ApduExchange.exchangeApdu(this.device, 224, 78, 128, 0, out.toByteArray());
        response.checkSW();
        byte[] signatureResponse = Arrays.copyOfRange(response.getResponse(), 0, response.getResponse().length - 2);
        return new ECDSADeviceSignature(signatureResponse[0] - 48, signatureResponse);
    }

    private class TXInput {
        private InputType inputType;
        private byte[] value;

        public TXInput(InputType inputType, byte[] value) {
            this.inputType = inputType;
            this.value = value;
        }

        public InputType getInputType() {
            return this.inputType;
        }

        public byte[] getValue() {
            return this.value;
        }
    }

    private static enum InputType {
        INPUT_TRUSTED,
        INPUT_WITNESS;

    }

    public static enum AddressFormat {
        LEGACY,
        P2SH,
        BECH32;

    }
}

