/*
 * Decompiled with CFR 0.152.
 */
package com.ledger.lib.transport;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.hardware.usb.UsbRequest;
import android.util.Log;
import com.ledger.lib.LedgerException;
import com.ledger.lib.transport.LedgerDevice;
import com.ledger.lib.transport.LedgerWrapper;
import com.ledger.lib.utils.Dump;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;

public class LedgerDeviceUSB
implements LedgerDevice {
    public static final int LEDGER_VENDOR = 11415;
    private static final int HID_BUFFER_SIZE = 64;
    private static final int LEDGER_DEFAULT_CHANNEL = 1;
    private static final int SW1_DATA_AVAILABLE = 97;
    private static final int MAX_FRAGMENT_SIZE = 255;
    private static final String LOG_STRING = "LedgerDeviceUSB";
    private UsbManager manager;
    private UsbDevice device;
    private UsbDeviceConnection connection;
    private UsbInterface dongleInterface;
    private UsbEndpoint in;
    private UsbEndpoint out;
    private byte[] transferBuffer;
    private boolean debug;

    public LedgerDeviceUSB(UsbManager manager, UsbDevice device) {
        this.manager = manager;
        this.device = device;
        this.transferBuffer = new byte[64];
    }

    @Override
    public void open() throws LedgerException {
        this.connection = null;
        this.dongleInterface = this.device.getInterface(0);
        if (this.dongleInterface == null) {
            throw new LedgerException(LedgerException.ExceptionReason.IO_ERROR, "Failed to retrieve interface");
        }
        this.in = null;
        this.out = null;
        for (int i = 0; i < this.dongleInterface.getEndpointCount(); ++i) {
            UsbEndpoint tmpEndpoint = this.dongleInterface.getEndpoint(i);
            if (tmpEndpoint.getDirection() == 128) {
                this.in = tmpEndpoint;
                continue;
            }
            this.out = tmpEndpoint;
        }
        if (this.in == null || this.out == null) {
            throw new LedgerException(LedgerException.ExceptionReason.IO_ERROR, "Failed to retrieve endpoint");
        }
        this.connection = this.manager.openDevice(this.device);
        if (this.connection == null) {
            throw new LedgerException(LedgerException.ExceptionReason.IO_ERROR, "Failed to open device");
        }
        if (!this.connection.claimInterface(this.dongleInterface, true)) {
            this.close();
            throw new LedgerException(LedgerException.ExceptionReason.IO_ERROR, "Failed to claim interface");
        }
    }

    @Override
    public byte[] exchange(byte[] apdu) throws LedgerException {
        ByteArrayOutputStream response = new ByteArrayOutputStream();
        byte[] responseData = null;
        int offset = 0;
        if (this.debug) {
            Log.d((String)LOG_STRING, (String)("=> " + Dump.dump(apdu)));
        }
        apdu = LedgerWrapper.wrapCommandAPDU(1, apdu, 64);
        UsbRequest request = new UsbRequest();
        request.initialize(this.connection, this.out);
        while (offset != apdu.length) {
            int blockSize = apdu.length - offset > 64 ? 64 : apdu.length - offset;
            System.arraycopy(apdu, offset, this.transferBuffer, 0, blockSize);
            request.queue(ByteBuffer.wrap(this.transferBuffer), 64);
            this.connection.requestWait();
            offset += blockSize;
        }
        ByteBuffer responseBuffer = ByteBuffer.allocate(64);
        request = new UsbRequest();
        request.initialize(this.connection, this.in);
        while ((responseData = LedgerWrapper.unwrapResponseAPDU(1, response.toByteArray(), 64)) == null) {
            responseBuffer.clear();
            request.queue(responseBuffer, 64);
            this.connection.requestWait();
            responseBuffer.rewind();
            responseBuffer.get(this.transferBuffer, 0, 64);
            response.write(this.transferBuffer, 0, 64);
        }
        if (this.debug) {
            Log.d((String)LOG_STRING, (String)("<= " + Dump.dump(responseData)));
        }
        return responseData;
    }

    @Override
    public void close() throws LedgerException {
        if (this.connection != null) {
            if (this.dongleInterface != null) {
                this.connection.releaseInterface(this.dongleInterface);
                this.dongleInterface = null;
            }
            this.connection.close();
            this.connection = null;
        }
    }

    @Override
    public void setDebug(boolean debugFlag) {
        this.debug = debugFlag;
    }

    @Override
    public boolean isOpened() {
        return this.connection != null;
    }
}

