/*
 * Decompiled with CFR 0.152.
 */
package com.leafready.ads.utils;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import com.leafready.ads.utils.DebugConfigs;

public class LogUtils {
    public static void loge(Context context, String message) {
        LogUtils.loge(context, "", message);
    }

    public static void loge(Context context, String tag, String message) {
        if (DebugConfigs.isDebugEnable(context)) {
            LogUtils.logHandler(context, tag, message, LogType.EXCEPTION);
        }
    }

    public static void loge(Context context, String tag, Exception exception) {
        if (DebugConfigs.isDebugEnable(context)) {
            LogUtils.logHandler(context, tag, exception.getMessage(), LogType.EXCEPTION);
            exception.printStackTrace();
        }
    }

    public static void loge(Context context, Exception exception) {
        LogUtils.loge(context, "", exception.getMessage());
    }

    public static void showToast(Context context, String message) {
        if (DebugConfigs.isDebugEnable(context)) {
            Toast.makeText((Context)context, (CharSequence)message, (int)0).show();
        }
    }

    public static void log(Context context, String tag, String message) {
        if (DebugConfigs.isDebugEnable(context)) {
            LogUtils.logHandler(context, tag, message, LogType.DEBUG);
        }
    }

    public static void log(Context context, String message) {
        LogUtils.log(context, "", message);
    }

    private static void logHandler(Context context, String tag, String message, LogType logType) {
        try {
            String fullClassName = Thread.currentThread().getStackTrace()[3].getClassName();
            String className = fullClassName.substring(fullClassName.lastIndexOf(".") + 1);
            if (className.contains("$")) {
                className = className.substring(0, className.lastIndexOf("$"));
            }
            String methodName = Thread.currentThread().getStackTrace()[3].getMethodName();
            int lineNumber = Thread.currentThread().getStackTrace()[3].getLineNumber();
            String tagDebug = DebugConfigs.getTag(context);
            if (!TextUtils.isEmpty((CharSequence)tag)) {
                tagDebug = tag;
            }
            String logMessage = "at (" + className + ".java:" + lineNumber + ") [" + methodName + "]" + message;
            if (logType == LogType.EXCEPTION) {
                Log.e((String)tagDebug, (String)logMessage);
                return;
            }
            Log.d((String)tagDebug, (String)logMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static enum LogType {
        DEBUG,
        EXCEPTION;

    }
}

