/*
 * Decompiled with CFR 0.152.
 */
package com.leafready.ads.dialogs;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import com.leafready.ads.R;
import com.leafready.ads.adapters.Type13PagerAdapter;
import com.leafready.ads.autoscrollviewpager.AutoScrollViewPager;
import com.leafready.ads.dialogs.BaseDialog;
import com.leafready.ads.models.MAd;
import com.leafready.ads.models.MAdItem;
import com.leafready.ads.utils.DeviceUtils;
import com.leafready.ads.utils.GifUtils;
import com.leafready.ads.utils.TouchOutSideDialogContentDetector;
import com.leafready.ads.utils.UpdateViewUtils;
import com.leafready.ads.views.MobileIndicator;
import java.util.ArrayList;

public class Type_1_3_Dialog
extends BaseDialog {
    private final String TAG = Type_1_3_Dialog.class.getSimpleName();
    protected View rootView;
    protected ImageButton btnClose;
    protected AutoScrollViewPager viewPager;
    private boolean isEncrypted;
    private ArrayList<MAdItem> adItems;
    private MobileIndicator layoutIndicators;
    private Type13PagerAdapter pagerAdapter;
    private GestureDetector gestureDetector;

    public Type_1_3_Dialog(Activity activity, MAd model) {
        super(activity, model);
        this.gestureDetector = new GestureDetector((Context)activity, (GestureDetector.OnGestureListener)new TouchOutSideDialogContentDetector(this));
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            this.setContentView(R.layout.dialog_popup_1_3_);
            this.isEncrypted = true;
            this.rootView = this.findViewById(R.id.layout_root);
            this.btnClose = (ImageButton)this.findViewById(R.id.btn_close);
            this.adItems = this.model.getAdItems();
            this.viewPager = (AutoScrollViewPager)this.findViewById(R.id.view_pager);
            this.pagerAdapter = new Type13PagerAdapter(this.adItems, this.isEncrypted, this);
            this.viewPager.setAdapter(this.pagerAdapter);
            this.layoutIndicators = (MobileIndicator)this.findViewById(R.id.layout_indicator);
            this.layoutIndicators.setViewPager(this.viewPager);
            this.rootView.setOnTouchListener(new View.OnTouchListener(){

                @SuppressLint(value={"ClickableViewAccessibility"})
                public boolean onTouch(View view, MotionEvent event) {
                    try {
                        Type_1_3_Dialog.this.gestureDetector.onTouchEvent(event);
                        return true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            });
            this.btnClose.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    try {
                        Type_1_3_Dialog.this.dismiss();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            if (this.model.getAutoSlideTime() > 0) {
                this.viewPager.setInterval(this.model.getAutoSlideTime());
                this.viewPager.startAutoScroll();
            }
            UpdateViewUtils.updatWhenViewTreeLoaded((Context)this.activity, (View)this.viewPager, new UpdateViewUtils.ViewTreeListener(){

                @Override
                public void done() {
                    try {
                        MAdItem adItem = (MAdItem)Type_1_3_Dialog.this.adItems.get(0);
                        if (adItem == null) {
                            return;
                        }
                        byte[] bytes = adItem.getBannerData();
                        float[] optimalSize = GifUtils.loadBytesToGifImage((Context)Type_1_3_Dialog.this.activity, bytes, null, true);
                        int oRientation = DeviceUtils.getScreenOrientation((Context)Type_1_3_Dialog.this.activity);
                        ViewGroup.LayoutParams lp = Type_1_3_Dialog.this.viewPager.getLayoutParams();
                        if (oRientation == 1) {
                            lp.width = (int)(optimalSize[0] + 24.0f * DeviceUtils.getDensity((Context)Type_1_3_Dialog.this.activity));
                            lp.height = (int)(optimalSize[1] + 84.0f * DeviceUtils.getDensity((Context)Type_1_3_Dialog.this.activity));
                        } else {
                            lp.width = (int)(optimalSize[0] + 34.0f * DeviceUtils.getDensity((Context)Type_1_3_Dialog.this.activity));
                            lp.height = (int)(optimalSize[1] + 34.0f * DeviceUtils.getDensity((Context)Type_1_3_Dialog.this.activity));
                        }
                        if (lp.width <= 0) {
                            return;
                        }
                        Type_1_3_Dialog.this.viewPager.setLayoutParams(lp);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void show() {
        super.show();
    }
}

