/*
 * Decompiled with CFR 0.152.
 */
package com.leafready.ads.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Point;
import android.support.v4.app.Fragment;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

public class PagerContainer
extends FrameLayout
implements ViewPager.OnPageChangeListener {
    private ViewPager mPager;
    boolean mNeedsRedraw = false;
    boolean isOverlapEnabled = false;
    private Point mCenter = new Point();
    private Point mInitialTouch = new Point();
    private Point bindingTouch = new Point();

    public PagerContainer(Context context) {
        super(context);
        this.init();
    }

    public PagerContainer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public PagerContainer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.setClipChildren(false);
        this.setLayerType(1, null);
    }

    public void setOverlapEnabled(boolean overlapEnabled) {
        this.isOverlapEnabled = overlapEnabled;
    }

    @SuppressLint(value={"MissingSuperCall"})
    protected void onFinishInflate() {
        try {
            this.mPager = (ViewPager)this.getChildAt(0);
            this.mPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ViewPager getViewPager() {
        return this.mPager;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        Log.d((String)"@@@", (String)("w:" + w + "\nh: " + h));
        this.mCenter.x = w / 2;
        this.mCenter.y = h / 2;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        try {
            switch (ev.getAction()) {
                case 0: {
                    this.mInitialTouch.x = (int)ev.getX();
                    this.mInitialTouch.y = (int)ev.getY();
                }
            }
            float deltaX = this.mCenter.x - this.mInitialTouch.x;
            float deltaY = this.mCenter.y - this.mInitialTouch.y;
            ev.offsetLocation(deltaX, deltaY);
            return this.mPager.dispatchTouchEvent(ev);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        try {
            if (this.mNeedsRedraw) {
                this.invalidate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onPageSelected(int position) {
        try {
            if (this.isOverlapEnabled) {
                int loopCounter = 0;
                int PAGER_LOOP_THRESHOLD = 2;
                if (position >= PAGER_LOOP_THRESHOLD) {
                    loopCounter = position - PAGER_LOOP_THRESHOLD;
                }
                do {
                    if (loopCounter >= this.mPager.getAdapter().getCount()) continue;
                    Object object = this.mPager.getAdapter().instantiateItem((ViewGroup)this.mPager, loopCounter);
                    if (object instanceof Fragment) {
                        Fragment fragment = (Fragment)object;
                        if (loopCounter == position) {
                            ViewCompat.setElevation((View)fragment.getView(), (float)8.0f);
                            continue;
                        }
                        ViewCompat.setElevation((View)fragment.getView(), (float)0.0f);
                        continue;
                    }
                    ViewGroup view = (ViewGroup)object;
                    if (loopCounter == position) {
                        ViewCompat.setElevation((View)view, (float)8.0f);
                        continue;
                    }
                    ViewCompat.setElevation((View)view, (float)0.0f);
                } while (++loopCounter < position + PAGER_LOOP_THRESHOLD);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onPageScrollStateChanged(int state) {
        this.mNeedsRedraw = state != 0;
    }
}

