package com.leafready.ads.views;

import android.app.Activity;
import android.content.Context;
import android.database.DataSetObserver;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;

public class StickyHorizontalScrollView extends HorizontalScrollView {

	Context context;
	int prevIndex = 0;
	BaseAdapter adapter;

	private final DataSetObserver observer = new DataSetObserver() {

        @Override
        public void onChanged() {
            refreshViewsFromAdapter();
        }

        @Override
        public void onInvalidated() {
            removeAllViews();
        }
    };
	
	public StickyHorizontalScrollView(Context context) {
        super(context);
        this.context = context;
        this.setSmoothScrollingEnabled(true);
        this.setHorizontalScrollBarEnabled(false);
    }

	public StickyHorizontalScrollView(Context context, AttributeSet attrs) {
    	super(context, attrs);
		this.context = context;
		this.setSmoothScrollingEnabled(true);
		this.setHorizontalScrollBarEnabled(false);
    }

    public StickyHorizontalScrollView(Context context, AttributeSet attrs, int defStyle) {
    	super(context, attrs);
		this.context = context;
		this.setSmoothScrollingEnabled(true);
		this.setHorizontalScrollBarEnabled(false);
    }

	public void setAdapter(Context context, BaseAdapter mAdapter) {
		try {
			//		adapter = mAdapter;
//		adapter.setScrollView(this);
//		refreshViewsFromAdapter();
			if (adapter != null) {
				adapter.unregisterDataSetObserver(observer);
			}
			adapter = mAdapter;
			if (adapter != null) {
				adapter.registerDataSetObserver(observer);
			}
			initViewsFromAdapter();
		}catch (Exception e){
			e.printStackTrace();
		}
	}
	
	protected void initViewsFromAdapter() {
        try {
			ViewGroup parent = (ViewGroup) getChildAt(0);
			parent.removeAllViews();
			for (int i = 0; i < adapter.getCount(); i++) {
				parent.addView(adapter.getView(i, null, parent));
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

    protected void refreshViewsFromAdapter() {
        try {
			int childCount = getChildCount();
			int adapterSize = adapter.getCount();
			int reuseCount = Math.min(childCount, adapterSize);

			ViewGroup parent = (ViewGroup) getChildAt(0);

			for (int i = 0; i < reuseCount; i++) {
				adapter.getView(i, parent.getChildAt(i), this);
			}

			if (childCount < adapterSize) {
				for (int i = childCount; i < adapterSize; i++) {
					parent.addView(adapter.getView(i, null, this), i);
				}
			} else if (childCount > adapterSize) {
				parent.removeViews(adapterSize, childCount);
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}
	
	@SuppressWarnings("deprecation")
	public void setCenter(Activity context , int index) {

		try {
			ViewGroup parent = (ViewGroup) getChildAt(0);

			View preView = parent.getChildAt(prevIndex);
			LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(
					LinearLayout.LayoutParams.WRAP_CONTENT,
					LinearLayout.LayoutParams.WRAP_CONTENT);
			lp.setMargins(5, 5, 5, 5);
			preView.setLayoutParams(lp);

			View view = parent.getChildAt(index);
			int screenWidth = ((Activity) context).getWindowManager()
					.getDefaultDisplay().getWidth();

			int scrollX = (view.getLeft() - (screenWidth / 2))
					+ (view.getWidth() / 2);
			this.smoothScrollTo(scrollX, 0);
			prevIndex = index;
		}catch (Exception e){
			e.printStackTrace();
		}
	}
//	private int lX , computeRange;
	@Override
	protected void onScrollChanged(int l, int t, int oldl, int oldt) {
		try {
			// TODO Auto-generated method stub
			super.onScrollChanged(l, t, oldl, oldt);
			Log.d("abc", "tham so:" + l +"," + t + "," + oldl + "," + oldt);
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	int sizeElement;
	public int getItemHorizontal(int width , int listSize){
		try {
			int computeRange = computeHorizontalScrollRange();
			int offset = computeHorizontalScrollOffset();
			int sizeHorizontal = computeRange - width;
			sizeElement = sizeHorizontal/listSize;
			if (offset > (sizeElement*4)) {
				return 4;
			} else if(offset > (sizeElement * 3)) {
				return 3;
			} else if(offset > (sizeElement * 2)) {
				return 2;
			} else if(offset > (sizeElement * 1)) {
				return 1;
			} else {
				return 0;
			}
		}catch (Exception e){
			e.printStackTrace();
			return 0;
		}
	}

}
