package com.leafready.ads.utils;

import android.content.Context;
import android.content.res.AssetManager;

import java.io.InputStream;
import java.util.Properties;

public class DebugConfigs {
	private final static String TAG = "AD-SDK";
	private final static String PROPERTY_DEBUG = "debug";
	private final static String PROPERTY_TAG = "tag";
	private final static String CONFIG_FILE_NAME = "configs.properties";
	private final static boolean DEBUG = false;
	private static Properties properties = new Properties();
	
	public static boolean isDebugEnable(Context context) {
		
//		try {
//			Properties properties = getProperties(context);
//			Log.d(TAG, "configs: " + properties);
//			if(properties.isEmpty()){
//				return false;
//			}
//
//			return "true".equals(properties.getProperty(PROPERTY_DEBUG));
//		} catch (Exception exception) {
//			return false;
//		}
		return DEBUG;
	}

	public static String getTag(Context context) {
		Properties properties;
		try {
			properties = getProperties(context);
			if(properties.isEmpty()){
				return TAG;
			}
			if(properties.contains(PROPERTY_TAG)){
				return properties.getProperty(PROPERTY_TAG);	
			}
			return TAG;
		} catch (Exception e) {
			return TAG;
		}
	}
	
	private static Properties getProperties(Context context) throws Exception {
		try {
			if(!properties.isEmpty()){
				return properties;
			}

			properties.load(context.getClassLoader().getResourceAsStream("META-INF/" + CONFIG_FILE_NAME));

			if(!properties.isEmpty()){
				return properties;
			}
			AssetManager assetManager = context.getAssets();
			InputStream inputStream = assetManager.open(CONFIG_FILE_NAME);
			properties.load(inputStream);
			return properties;
		}catch (Exception e){
			e.printStackTrace();
			return properties;
		}
	}
}
