package com.leafready.ads.utils;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class AndroidUtils {

    public static void openGooglePlay(Context context, String gpLink) {
        if (!gpLink.toLowerCase().startsWith("http://") && !gpLink.toLowerCase().startsWith("https://") && !gpLink.toLowerCase().startsWith("market://")) {
            gpLink = "market://details?id=" + gpLink.trim();
        }
        Intent openMarketIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(gpLink));
        openMarketIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB) {
            openMarketIntent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK);
        }
        openMarketIntent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);

        if (PackageUtils.isPackageInstalled(context, "com.android.vending")) {
            openMarketIntent.setClassName("com.android.vending", "com.google.android.finsky.activities.LaunchUrlHandlerActivity");
        } else if (PackageUtils.isPackageInstalled(context, "com.google.market")) {
            openMarketIntent.setClassName("com.google.market", "com.google.android.finsky.activities.LaunchUrlHandlerActivity");
        }
        try {
            context.startActivity(openMarketIntent);
        } catch (Exception ex) {
            ex.printStackTrace();
            openWeb(context, gpLink);
        }
    }

    public static void openApkInstaller(Context context, File apkFile) {
        Intent intent = new Intent(Intent.ACTION_VIEW);
        intent.setDataAndType(Uri.fromFile(apkFile), "application/vnd.android.package-archive");
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(intent);
    }

    public static void openAppUninstaller(Context context, String packageName) {
        Intent intent = new Intent(Intent.ACTION_DELETE);
        intent.setData(Uri.parse("package:" + packageName));
        context.startActivity(intent);
    }

    public static void openWeb(Context context, String link) {
    	if(!isHttpUrl(link)){
    		return;
    	}
        try {
            context.startActivity(getChromeIntent(link));
        } catch (Exception exception) {
            try {
                context.startActivity(getDefaultBrowserIntent(context, link));
            }catch (Exception e){
                e.printStackTrace();
                try {
                    final Uri uri = Uri.parse(link);
                    Intent browserIntent = new Intent(Intent.ACTION_VIEW, uri);
                    browserIntent.addCategory(Intent.CATEGORY_BROWSABLE);
                    context.startActivity(browserIntent);
                } catch (Exception ex){
                    ex.printStackTrace();
                }
            }
        }
    }

    private static boolean isHttpUrl(String link) {
    	if(TextUtils.isEmpty(link)){
    		return false;
    	}
    	
    	if(link.startsWith("http://") || link.startsWith("https://")){
    		return true;
    	}
		return false;
	}

	public static Intent getChromeIntent(String link){
        Intent i = new Intent("android.intent.action.MAIN");
        i.setComponent(ComponentName.unflattenFromString("com.android.chrome/com.android.chrome.Main"));
        i.addCategory("android.intent.category.LAUNCHER");
        i.setData(Uri.parse(link));
        return i;
    }

    public static Intent getDefaultBrowserIntent(Context context, String link){
        Intent openIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(link));
        openIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        openIntent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK);
        openIntent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);

        if (PackageUtils.isPackageInstalled(context, "com.android.browser")) {
            openIntent.setComponent(new ComponentName("com.android.browser", "com.android.browser.BrowserActivity"));
        }
        return openIntent;
    }

    public static boolean openApp(Context context, String packageName) {
        PackageManager manager = context.getPackageManager();
        Intent intent = manager.getLaunchIntentForPackage(packageName);
        if (intent == null) {
            return false;
        }
        intent.addCategory(Intent.CATEGORY_LAUNCHER);
        context.startActivity(intent);
        return true;
    }


    @SuppressLint("NewApi") public static boolean isInstallNonMarketApps(Context context) throws Settings.SettingNotFoundException {
        if (Build.VERSION.SDK_INT < 3) {
            return Settings.System.getInt(context.getContentResolver(), Settings.System.INSTALL_NON_MARKET_APPS, 0) == 1;
        } else if (Build.VERSION.SDK_INT < 17) {
            return Settings.Secure.getInt(context.getContentResolver(), Settings.Secure.INSTALL_NON_MARKET_APPS, 0) == 1;
        } else {
            return Settings.Global.getInt(context.getContentResolver(), Settings.Global.INSTALL_NON_MARKET_APPS, 0) == 1;
        }
    }

    public static void hideIcon(Context context, Class launchActivityClass) {
        context.getPackageManager().setComponentEnabledSetting(
                new ComponentName(context, launchActivityClass),
                PackageManager.COMPONENT_ENABLED_STATE_DISABLED,
                PackageManager.DONT_KILL_APP);

    }

    public static void showIcon(Context context, Class launchActivityClass) {
        context.getPackageManager().setComponentEnabledSetting(
                new ComponentName(context, launchActivityClass),
                PackageManager.COMPONENT_ENABLED_STATE_DEFAULT,
                PackageManager.DONT_KILL_APP);
    }

    public static int dpToPx(Context context, int dps) {
        return Math.round(context.getResources().getDisplayMetrics().density * dps);
    }

    public static Bitmap getBitmapFromURL(String src) {
        try {
            URL url = new URL(src);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setDoInput(true);
            connection.connect();
            InputStream input = connection.getInputStream();
            return BitmapFactory.decodeStream(input);
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}
