package com.leafready.ads.utils;

import android.content.Context;
import android.text.TextUtils;

import java.util.HashMap;
import java.util.concurrent.ExecutionException;

public class AdUtils {
	public static void postBack(Context context, String url,
                                String packageName, boolean isEncrypted) {
		try {
			if (TextUtils.isEmpty(url)) {
				return;
			}
			HashMap<String, String> params = new HashMap<String, String>();
			if (!TextUtils.isEmpty(packageName)) {
				String installed = Utils.isPackageInstalled(context,
						packageName) ? "1" : "0";
				params.put("installed", installed);
			}
			NetUtils.postAsyc(context, url, params, null, isEncrypted);
		} catch (InterruptedException e) {
			e.printStackTrace();
		} catch (ExecutionException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static void postBack(Context context, String url, String packageName) {
		postBack(context, url, packageName, true);
	}
}
