package com.leafready.ads.adapters;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.leafready.ads.OrientationState;
import com.leafready.ads.R;
import com.leafready.ads.dialogs.BaseDialog;
import com.leafready.ads.dialogs.Type5Dialog;
import com.leafready.ads.models.MAdItem;
import com.leafready.ads.utils.DeviceUtils;
import com.leafready.ads.utils.GifUtils;
import com.leafready.ads.utils.LogUtils;
import com.leafready.ads.utils.UpdateViewUtils;
import com.leafready.ads.utils.Utils;
import com.leafready.ads.views.MobileImageView;

import java.util.ArrayList;

/**
 * Created by hnc on 6/9/2017.
 */


public class Type5PagerAdapter extends PagerAdapter {
    private ArrayList<MAdItem> adsItem;
    private boolean isEncrypted;
    private Activity activity;
    private Type5Dialog dialog;
    public Type5PagerAdapter(ArrayList<MAdItem> listItem, boolean isEncrypted, BaseDialog dialog) {
        adsItem = listItem;
        activity = dialog.getActivity();
        this.dialog = (Type5Dialog) dialog;
        this.isEncrypted = isEncrypted;
    }

    @SuppressLint({ "ClickableViewAccessibility", "InflateParams" })
    @Override
    public Object instantiateItem(ViewGroup container, final int position) {
        final MAdItem adItem = adsItem.get(position);
        View view = LayoutInflater.from(activity).inflate(R.layout.dialog_popup_5_item, null);
        LinearLayout layoutGameName = (LinearLayout) view.findViewById(R.id.layout_game_name);
        final MobileImageView bannerImage = (MobileImageView) view.findViewById(R.id.item_imageview);
        TextView txtGameName = (TextView) view.findViewById(R.id.txt_game_name);
        TextView txtCoin = (TextView) view.findViewById(R.id.txt_Mobilecoin);
        Button btnCategoryName = (Button) view.findViewById(R.id.btn_category_game);
        RelativeLayout layoutDownload = (RelativeLayout) view.findViewById(R.id.layout_game_download);
        String title;
        try {
            boolean isTablet = activity.getResources().getBoolean(R.bool.isTablet);
            if (isTablet) {
                title = adItem.getTitle();
            } else {
                title = Utils.splitString(adItem.getTitle());
            }
            txtGameName.setText(title);

            if (adsItem.get(position).getCoin() > 0) {
                txtCoin.setVisibility(View.VISIBLE);
                txtCoin.setText("+" + adItem.getCoin());
            } else {
                txtCoin.setVisibility(View.INVISIBLE);
            }

            int oRientation = DeviceUtils.getScreenOrientation(activity);
            TextView txtDownload = (TextView) view
                    .findViewById(R.id.txt_download);
            if (oRientation == OrientationState.LANDSCAPE
                    && adItem.getCoin() != 0 && txtDownload != null) {
                int paddingRight = Utils.dpToPx(activity, 20);
                txtDownload.setPadding(0, 0, paddingRight, 0);
            }
            byte[] bytes = adItem.getBannerData();

            layoutDownload.setOnClickListener(dialog.onClickListener);
            layoutGameName.setOnClickListener(dialog.onClickListener);
            btnCategoryName.setOnClickListener(dialog.onClickListener);
            GifUtils.loadBytesToGifImage(activity, bytes, bannerImage, true);
            bannerImage.setViewListener(new MobileImageView.ImageViewListener() {

                @Override
                public void onClick(View view) {
                    dialog.onClickHandler(adItem);
                }

                @Override
                public void onLongPress(View view) {

                }

                @Override
                public void onScroll() {

                }

                @Override
                public void onHold() {

                }

                @Override
                public void onHoldRelease() {

                }
            });
            ((ViewPager) container).addView(view);

            UpdateViewUtils.updatWhenViewTreeLoaded(activity, view, new UpdateViewUtils.ViewTreeListener() {

                @Override
                public void done() {
                    Drawable drawable = bannerImage.getDrawable();
                    //you should call after the bitmap drawn
                    Rect bounds = drawable.getBounds();
                    int width = bounds.width();
                    dialog.pagerPadding = (int) ((DeviceUtils.getScreenWidthInPixels(activity) - width) / 2.5);
                    LogUtils.log(activity, "image size", "" + width);
                    dialog.updatePadding();
                }
            });
        }catch (Exception e){
            e.printStackTrace();
        }
        return view;
    }

    public MAdItem getCurrentItem(int position){
        try {
            return  adsItem.get(position);
        }catch (Exception e){
            e.printStackTrace();
            return new MAdItem();
        }
    }



    @Override
    public void destroyItem(ViewGroup container, int position, Object object) {
        try {
            container.removeView((View) object);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    @Override
    public int getCount() {
        try {
            return adsItem.size();
        }catch (Exception e){
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public boolean isViewFromObject(View view, Object object) {
        try {
            return (view == object);
        }catch (Exception e){
            e.printStackTrace();
            return false;
        }
    }

}