/*
 * Decompiled with CFR 0.152.
 */
package com.leafready.ads.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.leafready.ads.R;

public class MobileIndicator
extends LinearLayout {
    private SparseArray<ImageButton> btnIndicators;
    private LinearLayout layoutIndicators;
    private String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private boolean init = false;
    private View rootView;
    private ViewPager mViewPager;
    private int numberOfItem;
    private final ViewPager.OnPageChangeListener mInternalPageChangeListener = new ViewPager.OnPageChangeListener(){

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            try {
                if (MobileIndicator.this.mViewPager.getAdapter() == null || MobileIndicator.this.mViewPager.getAdapter().getCount() <= 0) {
                    return;
                }
                MobileIndicator.this.updatePosition(position);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onPageSelected(int position) {
        }

        public void onPageScrollStateChanged(int state) {
        }
    };
    private Context indicatorContext;

    public MobileIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    @SuppressLint(value={"InflateParams"})
    private void init(Context context) {
        try {
            this.setIndicatorContext(context);
            if (this.init) {
                return;
            }
            this.rootView = LayoutInflater.from((Context)context).inflate(R.layout.indicator_view, null);
            this.layoutIndicators = (LinearLayout)this.rootView.findViewById(R.id.indicator);
            this.addView(this.rootView);
            this.init = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initialize() {
        try {
            Log.d((String)this.TAG, (String)("number of indicator: " + this.numberOfItem));
            if (this.numberOfItem <= 1) {
                this.setVisibility(8);
                return;
            }
            this.btnIndicators = new SparseArray();
            for (int i = 0; i < this.numberOfItem; ++i) {
                float density = this.getDensity(this.indicatorContext);
                int padding = (int)(4.0f * density);
                ImageButton btnIndicator = new ImageButton(this.indicatorContext);
                btnIndicator.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
                if (i == 0) {
                    btnIndicator.setImageResource(R.drawable.indicator_white);
                } else {
                    btnIndicator.setImageResource(R.drawable.indicator_inactive);
                }
                btnIndicator.setBackgroundResource(0);
                btnIndicator.setScaleType(ImageView.ScaleType.FIT_XY);
                btnIndicator.setPadding(padding, 0, padding, 0);
                this.layoutIndicators.addView((View)btnIndicator);
                this.btnIndicators.put(i, (Object)btnIndicator);
            }
            this.setVisibility(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updatePosition(int index) {
        try {
            if (this.btnIndicators == null) {
                return;
            }
            int itemSize = this.btnIndicators.size();
            for (int i = 0; i < itemSize; ++i) {
                if (i == index) {
                    ((ImageButton)this.btnIndicators.get(i)).setImageResource(R.drawable.indicator_white);
                    continue;
                }
                ((ImageButton)this.btnIndicators.get(i)).setImageResource(R.drawable.indicator_inactive);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private float getDensity(Context context) {
        try {
            return context.getResources().getDisplayMetrics().density;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    public MobileIndicator setNumberOfItem(int numberOfItem) {
        this.numberOfItem = numberOfItem;
        return this;
    }

    public MobileIndicator setViewPager(ViewPager mViewpager) {
        try {
            this.mViewPager = mViewpager;
            if (mViewpager != null && mViewpager.getAdapter() != null) {
                this.numberOfItem = this.mViewPager.getAdapter().getCount();
            }
            this.mViewPager.addOnPageChangeListener(this.mInternalPageChangeListener);
            this.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public int getNumberOfItem() {
        return this.numberOfItem;
    }

    public Context getIndicatorContext() {
        return this.indicatorContext;
    }

    public void setIndicatorContext(Context indicatorContext) {
        this.indicatorContext = indicatorContext;
    }
}

