/*
 * Decompiled with CFR 0.152.
 */
package com.leafready.ads;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import com.leafready.ads.AdListener;
import com.leafready.ads.utils.GifUtils;
import com.leafready.ads.utils.Utils;
import com.leafready.ads.views.GifImageView;

abstract class AbstractAd {
    protected AdListener adListener;
    protected Status adStatus = Status.INIT;
    public static final int ERROR_CONNECTION = 100;
    public static final int ERROR_CORRUPTED = 101;
    public static final int ERROR_EMPTY = 102;
    public static final int ERROR_SERVER = 103;
    public static final long TIMEOUT = 30000L;

    AbstractAd() {
    }

    public void setAdListener(AdListener adListener) {
        this.adListener = adListener;
    }

    public abstract void loadAd();

    public boolean isLoading() {
        return this.adStatus == Status.LOADING;
    }

    public boolean isPartialLoaded() {
        return this.adStatus == Status.PARTIAL_LOADED;
    }

    public boolean isLoaded() {
        return this.adStatus == Status.LOADED;
    }

    protected boolean isInInitState() {
        return this.adStatus == Status.INIT;
    }

    public abstract void show();

    protected abstract boolean isShowing();

    protected abstract void close();

    void loadBytesToGifImageView(Activity a, byte[] bytes, GifImageView imageView) {
        if (!GifUtils.isGif(bytes)) {
            Bitmap bitmap = Utils.getBitmapfromBytes(bytes);
            float[] resizeImage = Utils.getProperSizeForIntertitialImage((Context)a, bitmap);
            Bitmap newBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)resizeImage[0]), (int)((int)resizeImage[1]), (boolean)true);
            imageView.setImageBitmap(newBitmap);
        } else {
            imageView.setBytes(bytes);
            imageView.startAnimation();
        }
    }

    public static enum Status {
        INIT,
        LOADING,
        PARTIAL_LOADED,
        LOADED,
        ERROR;

    }
}

