package com.leafready.ads.utils;

import android.annotation.SuppressLint;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnLongClickListener;
import android.view.View.OnTouchListener;

import java.util.Calendar;

public class ClickEventDetector {
	private static final String TAG = "ClickEventDetector";
	private static final int MAX_CLICK_DURATION = 150;
	private static boolean isHold = false;
	
	public interface ClickListener{
		void onClick(View view);
	}
	
	public static void setOnTouchEvent(ClickListener clickListener, View...views){
		try {
			for (int i = 0; i < views.length; i++) {
				setOnTouchEvent(views[i], clickListener);
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}
	
	public static void setOnTouchEvent(View view, final ClickListener listener){
		if(view == null){
			return;
		}
		
		view.setOnTouchListener(new OnTouchListener() {
			
			private long startClickTime;
			private long timeStartMoving;
			private long totalTimeMoving;
		
			@SuppressLint("ClickableViewAccessibility")
			@Override
			public boolean onTouch(View view, MotionEvent event) {
				
				try {
					switch (event.getAction()) {
						case MotionEvent.ACTION_DOWN:
							LogUtils.log(view.getContext(), TAG, "Touch view: down");
							isHold = false;
							startClickTime = Calendar.getInstance().getTimeInMillis();
							break;

						case MotionEvent.ACTION_MOVE:
							LogUtils.log(view.getContext(), TAG, "Touch view: move");
							if(timeStartMoving == 0){
								timeStartMoving = Calendar.getInstance().getTimeInMillis();
							}
							totalTimeMoving = Calendar.getInstance().getTimeInMillis() - timeStartMoving;
							break;

						case MotionEvent.ACTION_UP:
							timeStartMoving = 0;

							LogUtils.log(view.getContext(), TAG, String.format("Touch view: up. startClickTime: %s - totalTimeMoving: %s", startClickTime, totalTimeMoving));

							LogUtils.log(view.getContext(), TAG, String.format("Touch view: up. total startClickTime: %s", startClickTime));

							long clickDuration = Calendar.getInstance()
									.getTimeInMillis() - startClickTime + totalTimeMoving;

							LogUtils.log(view.getContext(), TAG, String.format("Touch view: up. total clickDuration: %s", clickDuration));

							if (clickDuration < MAX_CLICK_DURATION && !isHold) {
								listener.onClick(view);
							}

							totalTimeMoving = 0;

							break;
					}
				}catch (Exception e){
					e.printStackTrace();
				}
				return false;
			}
		});
		
		view.setOnLongClickListener(new OnLongClickListener() {
			
			@Override
			public boolean onLongClick(View arg0) {
				isHold = true;
				return false;
			}
		});
	}
}
