package com.leafready.ads.adapters;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.support.v4.view.PagerAdapter;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.leafready.ads.R;
import com.leafready.ads.dialogs.BaseDialog;
import com.leafready.ads.dialogs.Type_1_3_Dialog;
import com.leafready.ads.models.MAdItem;
import com.leafready.ads.utils.GifUtils;
import com.leafready.ads.utils.LogUtils;
import com.leafready.ads.views.MobileImageView;

import java.util.ArrayList;

/**
 * Created by hnc on 6/9/2017.
 */

public class Type13PagerAdapter extends PagerAdapter {

    private final String TAG = Type13PagerAdapter.class.getSimpleName();
    private ArrayList<MAdItem> adsItem;
    private boolean isEncrypted;
    private Activity activity;
    private Type_1_3_Dialog dialog;
    // private boolean isFistTime = true;

    public Type13PagerAdapter(ArrayList<MAdItem> listItem, boolean isEncrypted, BaseDialog dialog) {
        this.adsItem = listItem;
        this.isEncrypted = isEncrypted;
        this.dialog = (Type_1_3_Dialog) dialog;
        activity = dialog.getActivity();
    }

    @SuppressLint("InflateParams")
    @Override
    public Object instantiateItem(ViewGroup container, final int position) {

        View view = LayoutInflater.from(activity).inflate(
                R.layout.item_type_1_to_4, null);
        final MobileImageView bannerImage = (MobileImageView) view
                .findViewById(R.id.image_type_1_to_4);

        try {
            final MAdItem adItem = adsItem.get(position);
            if (adItem == null) {
                return view;
            }

            byte[] bytes = adItem.getBannerData();

            GifUtils.loadBytesToGifImage(activity, bytes, bannerImage, true);

            bannerImage.setViewListener(new MobileImageView.ImageViewListener() {

                @Override
                public void onLongPress(View view) {

                }

                @Override
                public void onClick(View view) {
                    LogUtils.log(activity, TAG, "banner image click");
//                AndroidUtils.openWeb(activity, adItem.getExternalUri().toString());
                    Intent browserIntent = new Intent(Intent.ACTION_VIEW, adItem.getExternalUri());
                    activity.startActivity(browserIntent);
                    dialog.dismiss();
                }

                @Override
                public void onScroll() {

                }

                @Override
                public void onHold() {

                }

                @Override
                public void onHoldRelease() {

                }
            });
            String tag = "banner-view-" + position;
            Log.d("TAG for view", tag);
            view.setTag(tag);
            container.addView(view);
        }catch (Exception e){
            e.printStackTrace();
        }
        return view;
    }

    @Override
    public void destroyItem(ViewGroup container, int position, Object object) {
        try {
            container.removeView((View) object);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    @Override
    public int getCount() {
        try {
            return adsItem.size();
        }catch (Exception e){
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public boolean isViewFromObject(View view, Object object) {
        try {
            return (view == object);
        }catch (Exception e){
            e.printStackTrace();
            return false;
        }
    }
}
