/*
 * Decompiled with CFR 0.152.
 */
package com.leafready.ads.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.leafready.ads.views.GifImageView;

public class MobileImageView
extends GifImageView
implements GestureDetector.OnGestureListener {
    private final String TAG = this.getClass().getSimpleName();
    private GestureDetector gestureScanner;
    private ImageViewListener listener;

    public GestureDetector getGestureDetector() {
        return this.gestureScanner;
    }

    public void setViewListener(ImageViewListener listener) {
        this.listener = listener;
    }

    public MobileImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void init(Context context) {
        this.gestureScanner = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)this);
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                try {
                    if (event.getAction() != 1) {
                        if (MobileImageView.this.listener != null) {
                            MobileImageView.this.listener.onHold();
                        }
                    } else if (MobileImageView.this.listener != null) {
                        MobileImageView.this.listener.onHoldRelease();
                    }
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
        });
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        boolean dispatch = super.dispatchTouchEvent(event);
        this.gestureScanner.onTouchEvent(event);
        return dispatch;
    }

    public boolean onDown(MotionEvent arg0) {
        return true;
    }

    public boolean onFling(MotionEvent arg0, MotionEvent arg1, float arg2, float arg3) {
        return false;
    }

    public void onLongPress(MotionEvent event) {
        try {
            this.listener.onLongPress((View)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean onScroll(MotionEvent arg0, MotionEvent arg1, float arg2, float arg3) {
        try {
            this.listener.onScroll();
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void onShowPress(MotionEvent arg0) {
    }

    public boolean onSingleTapUp(MotionEvent event) {
        try {
            Log.d((String)this.TAG, (String)"SINGLE tap detected!");
            this.listener.onClick((View)this);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static interface ImageViewListener {
        public void onClick(View var1);

        public void onLongPress(View var1);

        public void onScroll();

        public void onHold();

        public void onHoldRelease();
    }
}

