/*
 * Decompiled with CFR 0.152.
 */
package com.leafready.ads.views;

import android.graphics.Bitmap;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

class GifDecoder {
    private static final String TAG = GifDecoder.class.getSimpleName();
    public static final int STATUS_OK = 0;
    public static final int STATUS_FORMAT_ERROR = 1;
    public static final int STATUS_OPEN_ERROR = 2;
    protected static final int MAX_STACK_SIZE = 4096;
    private static final int DISPOSAL_UNSPECIFIED = 0;
    private static final int DISPOSAL_NONE = 1;
    private static final int DISPOSAL_BACKGROUND = 2;
    private static final int DISPOSAL_PREVIOUS = 3;
    protected int status;
    protected int width;
    protected int height;
    protected boolean gctFlag;
    protected int gctSize;
    protected int loopCount = 1;
    protected int[] gct;
    protected int[] act;
    protected int bgIndex;
    protected int bgColor;
    protected int pixelAspect;
    protected boolean lctFlag;
    protected int lctSize;
    protected ByteBuffer rawData;
    protected byte[] block = new byte[256];
    protected int blockSize = 0;
    protected short[] prefix;
    protected byte[] suffix;
    protected byte[] pixelStack;
    protected byte[] mainPixels;
    protected int[] mainScratch;
    protected int[] copyScratch;
    protected ArrayList<GifFrame> frames;
    protected GifFrame currentFrame;
    protected Bitmap previousImage;
    protected Bitmap currentImage;
    protected Bitmap renderImage;
    protected int framePointer;
    protected int frameCount;

    GifDecoder() {
    }

    public void advance() {
        try {
            if (this.frameCount > 0) {
                this.framePointer = (this.framePointer + 1) % this.frameCount;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getDelay(int n) {
        try {
            int delay = 0;
            if (n >= 0 && n < this.frameCount) {
                delay = this.frames.get((int)n).delay;
            }
            return delay;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getNextDelay() {
        try {
            if (this.frameCount <= 0 || this.framePointer < 0) {
                return 0;
            }
            return this.getDelay(this.framePointer);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public int getCurrentFrameIndex() {
        return this.framePointer;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public Bitmap getNextFrame() {
        try {
            if (this.frameCount <= 0 || this.framePointer < 0 || this.currentImage == null) {
                return null;
            }
            GifFrame frame = this.frames.get(this.framePointer);
            if (frame.lct == null) {
                this.act = this.gct;
            } else {
                this.act = frame.lct;
                if (this.bgIndex == frame.transIndex) {
                    this.bgColor = 0;
                }
            }
            int save = 0;
            if (frame.transparency) {
                save = this.act[frame.transIndex];
                this.act[frame.transIndex] = 0;
            }
            if (this.act == null) {
                Log.w((String)TAG, (String)"No Valid Color Table");
                this.status = 1;
                return null;
            }
            this.setPixels(this.framePointer);
            if (frame.transparency) {
                this.act[frame.transIndex] = save;
            }
            return this.currentImage;
        }
        catch (Exception e) {
            e.printStackTrace();
            Bitmap bitmap = Bitmap.createBitmap((int)100, (int)100, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.eraseColor(-1);
            return bitmap;
        }
    }

    public int read(InputStream is, int contentLength) {
        try {
            if (is != null) {
                try {
                    int nRead;
                    int capacity = contentLength > 0 ? contentLength + 4096 : 4096;
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream(capacity);
                    byte[] data = new byte[16384];
                    while ((nRead = is.read(data, 0, data.length)) != -1) {
                        buffer.write(data, 0, nRead);
                    }
                    buffer.flush();
                    this.read(buffer.toByteArray());
                }
                catch (IOException e) {
                    Log.w((String)TAG, (String)"Error reading data from stream", (Throwable)e);
                }
            } else {
                this.status = 2;
            }
            try {
                is.close();
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)"Error closing stream", (Throwable)e);
            }
            return this.status;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int read(byte[] data) {
        try {
            this.init();
            if (data != null) {
                this.rawData = ByteBuffer.wrap(data);
                this.rawData.rewind();
                this.rawData.order(ByteOrder.LITTLE_ENDIAN);
                this.readHeader();
                if (!this.err()) {
                    this.readContents();
                    if (this.frameCount < 0) {
                        this.status = 1;
                    }
                }
            } else {
                this.status = 2;
            }
            return this.status;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    protected void setPixels(int frameIndex) {
        try {
            GifFrame currentFrame = this.frames.get(frameIndex);
            GifFrame previousFrame = null;
            int previousIndex = frameIndex - 1;
            if (previousIndex >= 0) {
                previousFrame = this.frames.get(previousIndex);
            }
            int[] dest = this.mainScratch;
            if (previousFrame != null && previousFrame.dispose > 0) {
                if (previousFrame.dispose == 1 && this.currentImage != null) {
                    this.currentImage.getPixels(dest, 0, this.width, 0, 0, this.width, this.height);
                }
                if (previousFrame.dispose == 2) {
                    int c = 0;
                    if (!currentFrame.transparency) {
                        c = this.bgColor;
                    }
                    for (int i = 0; i < previousFrame.ih; ++i) {
                        int n1 = (previousFrame.iy + i) * this.width + previousFrame.ix;
                        int n2 = n1 + previousFrame.iw;
                        for (int k = n1; k < n2; ++k) {
                            dest[k] = c;
                        }
                    }
                }
                if (previousFrame.dispose == 3 && this.previousImage != null) {
                    this.previousImage.getPixels(dest, 0, this.width, 0, 0, this.width, this.height);
                }
            }
            this.decodeBitmapData(currentFrame, this.mainPixels);
            int pass = 1;
            int inc = 8;
            int iline = 0;
            for (int i = 0; i < currentFrame.ih; ++i) {
                int line = i;
                if (currentFrame.interlace) {
                    if (iline >= currentFrame.ih) {
                        switch (++pass) {
                            case 2: {
                                iline = 4;
                                break;
                            }
                            case 3: {
                                iline = 2;
                                inc = 4;
                                break;
                            }
                            case 4: {
                                iline = 1;
                                inc = 2;
                                break;
                            }
                        }
                    }
                    line = iline;
                    iline += inc;
                }
                if ((line += currentFrame.iy) >= this.height) continue;
                int k = line * this.width;
                int dx = k + currentFrame.ix;
                int dlim = dx + currentFrame.iw;
                if (k + this.width < dlim) {
                    dlim = k + this.width;
                }
                int sx = i * currentFrame.iw;
                while (dx < dlim) {
                    int index;
                    int c;
                    if ((c = this.act[index = this.mainPixels[sx++] & 0xFF]) != 0) {
                        dest[dx] = c;
                    }
                    ++dx;
                }
            }
            this.currentImage.getPixels(this.copyScratch, 0, this.width, 0, 0, this.width, this.height);
            this.previousImage.setPixels(this.copyScratch, 0, this.width, 0, 0, this.width, this.height);
            this.currentImage.setPixels(dest, 0, this.width, 0, 0, this.width, this.height);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void decodeBitmapData(GifFrame frame, byte[] dstPixels) {
        try {
            int code;
            int npix;
            if (frame != null) {
                this.rawData.position(frame.bufferFrameStart);
            }
            int nullCode = -1;
            int n = npix = frame == null ? this.width * this.height : frame.iw * frame.ih;
            if (dstPixels == null || dstPixels.length < npix) {
                dstPixels = new byte[npix];
            }
            if (this.prefix == null) {
                this.prefix = new short[4096];
            }
            if (this.suffix == null) {
                this.suffix = new byte[4096];
            }
            if (this.pixelStack == null) {
                this.pixelStack = new byte[4097];
            }
            int data_size = this.read();
            int clear = 1 << data_size;
            int end_of_information = clear + 1;
            int available = clear + 2;
            int old_code = -1;
            int code_size = data_size + 1;
            int code_mask = (1 << code_size) - 1;
            for (code = 0; code < clear; ++code) {
                this.prefix[code] = 0;
                this.suffix[code] = (byte)code;
            }
            int bi = 0;
            int pi = 0;
            int top = 0;
            int first = 0;
            int count = 0;
            int bits = 0;
            int datum = 0;
            int i = 0;
            while (i < npix) {
                if (top == 0) {
                    if (bits < code_size) {
                        if (count == 0) {
                            count = this.readBlock();
                            if (count <= 0) break;
                            bi = 0;
                        }
                        datum += (this.block[bi] & 0xFF) << bits;
                        bits += 8;
                        ++bi;
                        --count;
                        continue;
                    }
                    code = datum & code_mask;
                    datum >>= code_size;
                    bits -= code_size;
                    if (code > available || code == end_of_information) break;
                    if (code == clear) {
                        code_size = data_size + 1;
                        code_mask = (1 << code_size) - 1;
                        available = clear + 2;
                        old_code = -1;
                        continue;
                    }
                    if (old_code == -1) {
                        this.pixelStack[top++] = this.suffix[code];
                        old_code = code;
                        first = code;
                        continue;
                    }
                    int in_code = code;
                    if (code == available) {
                        this.pixelStack[top++] = (byte)first;
                        code = old_code;
                    }
                    while (code > clear) {
                        this.pixelStack[top++] = this.suffix[code];
                        code = this.prefix[code];
                    }
                    first = this.suffix[code] & 0xFF;
                    if (available >= 4096) break;
                    this.pixelStack[top++] = (byte)first;
                    this.prefix[available] = (short)old_code;
                    this.suffix[available] = (byte)first;
                    if ((++available & code_mask) == 0 && available < 4096) {
                        ++code_size;
                        code_mask += available;
                    }
                    old_code = in_code;
                }
                dstPixels[pi++] = this.pixelStack[--top];
                ++i;
            }
            for (i = pi; i < npix; ++i) {
                dstPixels[i] = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean err() {
        return this.status != 0;
    }

    protected void init() {
        try {
            this.status = 0;
            this.frameCount = 0;
            this.framePointer = -1;
            this.frames = new ArrayList();
            this.gct = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected int read() {
        try {
            int curByte = 0;
            try {
                curByte = this.rawData.get() & 0xFF;
            }
            catch (Exception e) {
                this.status = 1;
            }
            return curByte;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    protected int readBlock() {
        try {
            int n;
            this.blockSize = this.read();
            if (this.blockSize > 0) {
                try {
                    int count;
                    for (n = 0; n < this.blockSize; n += count) {
                        count = this.blockSize - n;
                        this.rawData.get(this.block, n, count);
                    }
                }
                catch (Exception e) {
                    Log.w((String)TAG, (String)"Error Reading Block", (Throwable)e);
                    this.status = 1;
                }
            }
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    protected int[] readColorTable(int ncolors) {
        int nbytes = 3 * ncolors;
        int[] tab = null;
        byte[] c = new byte[nbytes];
        try {
            this.rawData.get(c);
            tab = new int[256];
            int i = 0;
            int j = 0;
            while (i < ncolors) {
                int r = c[j++] & 0xFF;
                int g = c[j++] & 0xFF;
                int b = c[j++] & 0xFF;
                tab[i++] = 0xFF000000 | r << 16 | g << 8 | b;
            }
        }
        catch (BufferUnderflowException e) {
            Log.w((String)TAG, (String)"Format Error Reading Color Table", (Throwable)e);
            this.status = 1;
        }
        return tab;
    }

    protected void readContents() {
        try {
            boolean done = false;
            block13: while (!done && !this.err()) {
                int code = this.read();
                switch (code) {
                    case 44: {
                        this.readBitmap();
                        continue block13;
                    }
                    case 33: {
                        code = this.read();
                        switch (code) {
                            case 249: {
                                this.currentFrame = new GifFrame();
                                this.readGraphicControlExt();
                                continue block13;
                            }
                            case 255: {
                                this.readBlock();
                                String app = "";
                                for (int i = 0; i < 11; ++i) {
                                    app = app + (char)this.block[i];
                                }
                                if (app.equals("NETSCAPE2.0")) {
                                    this.readNetscapeExt();
                                    continue block13;
                                }
                                this.skip();
                                continue block13;
                            }
                            case 254: {
                                this.skip();
                                continue block13;
                            }
                            case 1: {
                                this.skip();
                                continue block13;
                            }
                        }
                        this.skip();
                        continue block13;
                    }
                    case 59: {
                        done = true;
                        continue block13;
                    }
                }
                this.status = 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void readHeader() {
        try {
            String id2 = "";
            for (int i = 0; i < 6; ++i) {
                id2 = id2 + (char)this.read();
            }
            if (!id2.startsWith("GIF")) {
                this.status = 1;
                return;
            }
            this.readLSD();
            if (this.gctFlag && !this.err()) {
                this.gct = this.readColorTable(this.gctSize);
                this.bgColor = this.gct[this.bgIndex];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void readGraphicControlExt() {
        try {
            this.read();
            int packed = this.read();
            this.currentFrame.dispose = (packed & 0x1C) >> 2;
            if (this.currentFrame.dispose == 0) {
                this.currentFrame.dispose = 1;
            }
            this.currentFrame.transparency = (packed & 1) != 0;
            this.currentFrame.delay = this.readShort() * 10;
            this.currentFrame.transIndex = this.read();
            this.read();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void readBitmap() {
        try {
            this.currentFrame.ix = this.readShort();
            this.currentFrame.iy = this.readShort();
            this.currentFrame.iw = this.readShort();
            this.currentFrame.ih = this.readShort();
            int packed = this.read();
            this.lctFlag = (packed & 0x80) != 0;
            this.lctSize = (int)Math.pow(2.0, (packed & 7) + 1);
            this.currentFrame.interlace = (packed & 0x40) != 0;
            this.currentFrame.lct = (int[])(this.lctFlag ? this.readColorTable(this.lctSize) : null);
            this.currentFrame.bufferFrameStart = this.rawData.position();
            this.skipBitmapData();
            if (this.err()) {
                return;
            }
            ++this.frameCount;
            this.frames.add(this.currentFrame);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void skipBitmapData() {
        this.read();
        this.skip();
    }

    protected void readLSD() {
        try {
            this.width = this.readShort();
            this.height = this.readShort();
            int packed = this.read();
            this.gctFlag = (packed & 0x80) != 0;
            this.gctSize = 2 << (packed & 7);
            this.bgIndex = this.read();
            this.pixelAspect = this.read();
            try {
                this.mainPixels = new byte[this.width * this.height];
                this.mainScratch = new int[this.width * this.height];
                this.copyScratch = new int[this.width * this.height];
                this.previousImage = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.RGB_565);
                this.currentImage = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.RGB_565);
            }
            catch (OutOfMemoryError e) {
                int dimension = this.width * this.height / 2;
                this.mainPixels = new byte[dimension];
                this.mainScratch = new int[dimension];
                this.copyScratch = new int[dimension];
                this.previousImage = Bitmap.createBitmap((int)(this.width / 2), (int)(this.height / 2), (Bitmap.Config)Bitmap.Config.RGB_565);
                this.currentImage = Bitmap.createBitmap((int)(this.width / 2), (int)(this.height / 2), (Bitmap.Config)Bitmap.Config.RGB_565);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void readNetscapeExt() {
        try {
            do {
                this.readBlock();
                if (this.block[0] != 1) continue;
                int b1 = this.block[1] & 0xFF;
                int b2 = this.block[2] & 0xFF;
                this.loopCount = b2 << 8 | b1;
            } while (this.blockSize > 0 && !this.err());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected int readShort() {
        try {
            return this.rawData.getShort();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    protected void skip() {
        try {
            do {
                this.readBlock();
            } while (this.blockSize > 0 && !this.err());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private static class GifFrame {
        public int ix;
        public int iy;
        public int iw;
        public int ih;
        public boolean interlace;
        public boolean transparency;
        public int dispose;
        public int transIndex;
        public int delay;
        public int bufferFrameStart;
        public int[] lct;

        private GifFrame() {
        }
    }
}

