/*
 * Decompiled with CFR 0.152.
 */
package com.leafready.ads.utils;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.util.Log;
import com.leafready.ads.utils.AdvertisingIdClient;
import com.leafready.ads.utils.DeviceUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Utils {
    static String checkInstall = "";
    private static String advertisingId = "";

    public static String splitString(String str) {
        try {
            if (str.length() > 15) {
                String s = str.substring(0, 13);
                s = s + "...";
                return s;
            }
            return str;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean isJSONObject(String jsonString) {
        try {
            if (TextUtils.isEmpty((CharSequence)jsonString)) {
                return false;
            }
            try {
                new JSONObject(jsonString);
            }
            catch (JSONException ex) {
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isJSONArray(String jsonString) {
        try {
            if (TextUtils.isEmpty((CharSequence)jsonString)) {
                return false;
            }
            try {
                new JSONArray(jsonString);
            }
            catch (JSONException ex) {
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getAdvertisingID(final Context context) {
        try {
            if (!TextUtils.isEmpty((CharSequence)advertisingId)) {
                return advertisingId;
            }
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        AdvertisingIdClient.AdInfo adInfo = AdvertisingIdClient.getAdvertisingIdInfo(context);
                        String adId = adInfo.getId();
                        Log.i((String)"Google Advertising id:", (String)("GA ID :" + adId));
                        advertisingId = adId;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return advertisingId + "";
    }

    public static String getVersionOS(Context context) {
        try {
            String release = Build.VERSION.RELEASE;
            Log.d((String)"version OS :", (String)("version OS :" + release));
            return "android-" + release + "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "android-";
        }
    }

    public static String getNetworkType(Context context) {
        try {
            ConnectivityManager conMan = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo netWorkInfo = conMan.getActiveNetworkInfo();
            if (netWorkInfo != null) {
                return netWorkInfo.getTypeName().toLowerCase();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getLanguage(Context context) {
        try {
            String deviceLocale = Locale.getDefault().getLanguage();
            Log.d((String)"language device :", (String)("language device :" + deviceLocale));
            return deviceLocale;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static Bitmap decodeBase64(String input) {
        byte[] decodedByte = Base64.decode((String)input, (int)0);
        return BitmapFactory.decodeByteArray((byte[])decodedByte, (int)0, (int)decodedByte.length);
    }

    public static String getSHACheckSum(String checksum) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(checksum.getBytes());
            byte[] byteData = md.digest();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < byteData.length; ++i) {
                sb.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getMD5CheckSumFromByteArray(byte[] byteArray) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(byteArray, 0, byteArray.length);
            BigInteger bi = new BigInteger(1, md5.digest());
            return String.format("%0" + (md5.digest().length << 1) + "x", bi);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static float[] getProperSizeForIntertitialImage(Context c, Bitmap bitmap) {
        float[] result = new float[2];
        try {
            float density = DeviceUtils.getDensity(c);
            float width_screen = DeviceUtils.getScreenWidthInPixels(c);
            float height_screen = (float)DeviceUtils.getScreenHeightInPixels(c) - 104.0f * density;
            float ratio_screen = width_screen / height_screen;
            float width_image = bitmap.getWidth();
            float height_image = bitmap.getHeight();
            float ratio_image = width_image / height_image;
            int orientation = DeviceUtils.getScreenOrientation(c);
            if (orientation == 1) {
                Log.d((String)"portrait", (String)"portrait");
                if (ratio_image < ratio_screen) {
                    height_image = height_screen - 60.0f * density;
                    result[0] = width_image = height_image * ratio_image;
                    result[1] = height_image;
                } else {
                    width_image = width_screen - 60.0f * density;
                    height_image = width_image / ratio_image;
                    result[0] = width_image;
                    result[1] = height_image;
                }
            } else {
                Log.d((String)"landscape", (String)"landscape");
                if (ratio_image < ratio_screen) {
                    height_image = height_screen;
                    result[0] = width_image = height_image * ratio_image;
                    result[1] = height_image;
                } else {
                    width_image = width_screen;
                    height_image = width_image / ratio_image;
                    result[0] = width_image;
                    result[1] = height_image;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static float[] getProperSizeForFeaturedImage(Context c, Bitmap bitmap) {
        float[] result = new float[2];
        try {
            float width_screen = DeviceUtils.getScreenWidthInPixels(c);
            float width_image = bitmap.getWidth();
            float height_image = bitmap.getHeight();
            float ratio_image = width_image / height_image;
            result[0] = width_screen;
            result[1] = width_screen / ratio_image;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean isPackageInstalled(Context context, String packageName) {
        try {
            PackageManager pm = context.getPackageManager();
            pm.getPackageInfo(packageName, 1);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static String getPackageName(Context c) {
        try {
            String PACKAGE_NAME = c.getApplicationContext().getPackageName();
            return PACKAGE_NAME;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String checkInstall() {
        return checkInstall;
    }

    public static void launchApplication(Activity activity, String packageName, String openUrl) {
        try {
            if (Utils.isPackageInstalled((Context)activity, packageName)) {
                checkInstall = "1";
                Intent launchIntent = activity.getPackageManager().getLaunchIntentForPackage(packageName);
                activity.startActivity(launchIntent);
            } else {
                Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)openUrl));
                activity.startActivity(browserIntent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getCurrentDayOfYear() {
        try {
            Calendar c = Calendar.getInstance(TimeZone.getDefault());
            return c.get(6);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static byte[] getBytesFromBitmap(Bitmap bitmap) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)stream);
        return stream.toByteArray();
    }

    public static Bitmap getBitmapfromBytes(byte[] image) {
        try {
            return BitmapFactory.decodeByteArray((byte[])image, (int)0, (int)image.length);
        }
        catch (Exception e) {
            e.printStackTrace();
            Bitmap bitmap = Bitmap.createBitmap((int)100, (int)100, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.eraseColor(-1);
            return bitmap;
        }
    }

    public static boolean isNetworkAvailable(Context context) {
        try {
            ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = manager.getActiveNetworkInfo();
            boolean isAvailable = false;
            if (networkInfo != null && networkInfo.isConnected()) {
                isAvailable = true;
            }
            return isAvailable;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int dpToPx(Context context, int dp) {
        try {
            DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
            int px = Math.round((float)dp * (displayMetrics.xdpi / 160.0f));
            return px;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int pxToDp(Context context, int px) {
        try {
            DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
            int dp = Math.round((float)px / (displayMetrics.xdpi / 160.0f));
            return dp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static void timerDelayEnableDismissProgressDialog(long time, final ProgressDialog d) {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                try {
                    d.setCancelable(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, time);
    }
}

