/*
 * Decompiled with CFR 0.152.
 */
package com.leafready.ads.utils;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import com.leafready.ads.utils.PackageUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class AndroidUtils {
    public static void openGooglePlay(Context context, String gpLink) {
        if (!(gpLink.toLowerCase().startsWith("http://") || gpLink.toLowerCase().startsWith("https://") || gpLink.toLowerCase().startsWith("market://"))) {
            gpLink = "market://details?id=" + gpLink.trim();
        }
        Intent openMarketIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)gpLink));
        openMarketIntent.addFlags(0x10000000);
        if (Build.VERSION.SDK_INT >= 11) {
            openMarketIntent.addFlags(32768);
        }
        openMarketIntent.addFlags(0x4000000);
        if (PackageUtils.isPackageInstalled(context, "com.android.vending")) {
            openMarketIntent.setClassName("com.android.vending", "com.google.android.finsky.activities.LaunchUrlHandlerActivity");
        } else if (PackageUtils.isPackageInstalled(context, "com.google.market")) {
            openMarketIntent.setClassName("com.google.market", "com.google.android.finsky.activities.LaunchUrlHandlerActivity");
        }
        try {
            context.startActivity(openMarketIntent);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AndroidUtils.openWeb(context, gpLink);
        }
    }

    public static void openApkInstaller(Context context, File apkFile) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setDataAndType(Uri.fromFile((File)apkFile), "application/vnd.android.package-archive");
        intent.setFlags(0x10000000);
        context.startActivity(intent);
    }

    public static void openAppUninstaller(Context context, String packageName) {
        Intent intent = new Intent("android.intent.action.DELETE");
        intent.setData(Uri.parse((String)("package:" + packageName)));
        context.startActivity(intent);
    }

    public static void openWeb(Context context, String link) {
        if (!AndroidUtils.isHttpUrl(link)) {
            return;
        }
        try {
            context.startActivity(AndroidUtils.getChromeIntent(link));
        }
        catch (Exception exception) {
            try {
                context.startActivity(AndroidUtils.getDefaultBrowserIntent(context, link));
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    Uri uri = Uri.parse((String)link);
                    Intent browserIntent = new Intent("android.intent.action.VIEW", uri);
                    browserIntent.addCategory("android.intent.category.BROWSABLE");
                    context.startActivity(browserIntent);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private static boolean isHttpUrl(String link) {
        if (TextUtils.isEmpty((CharSequence)link)) {
            return false;
        }
        return link.startsWith("http://") || link.startsWith("https://");
    }

    public static Intent getChromeIntent(String link) {
        Intent i = new Intent("android.intent.action.MAIN");
        i.setComponent(ComponentName.unflattenFromString((String)"com.android.chrome/com.android.chrome.Main"));
        i.addCategory("android.intent.category.LAUNCHER");
        i.setData(Uri.parse((String)link));
        return i;
    }

    public static Intent getDefaultBrowserIntent(Context context, String link) {
        Intent openIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)link));
        openIntent.addFlags(0x10000000);
        openIntent.addFlags(32768);
        openIntent.addFlags(0x4000000);
        if (PackageUtils.isPackageInstalled(context, "com.android.browser")) {
            openIntent.setComponent(new ComponentName("com.android.browser", "com.android.browser.BrowserActivity"));
        }
        return openIntent;
    }

    public static boolean openApp(Context context, String packageName) {
        PackageManager manager = context.getPackageManager();
        Intent intent = manager.getLaunchIntentForPackage(packageName);
        if (intent == null) {
            return false;
        }
        intent.addCategory("android.intent.category.LAUNCHER");
        context.startActivity(intent);
        return true;
    }

    @SuppressLint(value={"NewApi"})
    public static boolean isInstallNonMarketApps(Context context) throws Settings.SettingNotFoundException {
        if (Build.VERSION.SDK_INT < 3) {
            return Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"install_non_market_apps", (int)0) == 1;
        }
        if (Build.VERSION.SDK_INT < 17) {
            return Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"install_non_market_apps", (int)0) == 1;
        }
        return Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"install_non_market_apps", (int)0) == 1;
    }

    public static void hideIcon(Context context, Class launchActivityClass) {
        context.getPackageManager().setComponentEnabledSetting(new ComponentName(context, launchActivityClass), 2, 1);
    }

    public static void showIcon(Context context, Class launchActivityClass) {
        context.getPackageManager().setComponentEnabledSetting(new ComponentName(context, launchActivityClass), 0, 1);
    }

    public static int dpToPx(Context context, int dps) {
        return Math.round(context.getResources().getDisplayMetrics().density * (float)dps);
    }

    public static Bitmap getBitmapFromURL(String src) {
        try {
            URL url = new URL(src);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.connect();
            InputStream input = connection.getInputStream();
            return BitmapFactory.decodeStream((InputStream)input);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

