/*
 * Decompiled with CFR 0.152.
 */
package com.leafready.ads.dialogs;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.view.ViewPager;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.leafready.ads.R;
import com.leafready.ads.adapters.Type24PagerAdapter;
import com.leafready.ads.autoscrollviewpager.AutoScrollViewPager;
import com.leafready.ads.dialogs.BaseDialog;
import com.leafready.ads.models.MAd;
import com.leafready.ads.models.MAdItem;
import com.leafready.ads.utils.DeviceUtils;
import com.leafready.ads.utils.GifUtils;
import com.leafready.ads.utils.TouchOutSideDialogContentDetector;
import com.leafready.ads.utils.Utils;
import com.leafready.ads.views.MobileIndicator;
import java.util.ArrayList;

public class Type_2_4_Dialog
extends BaseDialog {
    private final String TAG = Type_2_4_Dialog.class.getSimpleName();
    protected View rootView;
    protected ImageButton btnClose;
    protected AutoScrollViewPager viewPager;
    protected TextView txtCoin;
    protected TextView txtNameGame;
    protected ArrayList<MAdItem> adItems;
    private boolean isEncrypted;
    private LinearLayout layoutGameName;
    private TextView txtDownload;
    private RelativeLayout layoutDownload;
    private Button btnCategoryName;
    private MobileIndicator layoutIndicators;
    private GestureDetector gestureDetector;
    private Type24PagerAdapter adsPagerAdapter;
    public View.OnClickListener onClickListener = new View.OnClickListener(){

        public void onClick(View arg0) {
            try {
                MAdItem adItem = Type_2_4_Dialog.this.adsPagerAdapter.getCurrentItem(Type_2_4_Dialog.this.viewPager.getCurrentItem());
                if (adItem == null) {
                    Type_2_4_Dialog.this.dismiss();
                    return;
                }
                Intent browserIntent = new Intent("android.intent.action.VIEW", adItem.getExternalUri());
                Type_2_4_Dialog.this.activity.startActivity(browserIntent);
                Type_2_4_Dialog.this.dismiss();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public Type_2_4_Dialog(Activity activity, MAd model) {
        super(activity, model);
        try {
            this.gestureDetector = new GestureDetector((Context)activity, (GestureDetector.OnGestureListener)new TouchOutSideDialogContentDetector(this));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            this.setContentView(R.layout.dialog_popup_2_4_);
            this.rootView = this.findViewById(R.id.layout_root);
            this.btnClose = (ImageButton)this.findViewById(R.id.btn_close);
            this.txtNameGame = (TextView)this.findViewById(R.id.txt_game_name);
            this.txtCoin = (TextView)this.findViewById(R.id.txt_Mobilecoin);
            this.viewPager = (AutoScrollViewPager)this.findViewById(R.id.view_pager);
            this.txtDownload = (TextView)this.findViewById(R.id.txt_download);
            this.btnCategoryName = (Button)this.findViewById(R.id.btn_category_game);
            this.layoutGameName = (LinearLayout)this.findViewById(R.id.layout_game_name);
            this.layoutDownload = (RelativeLayout)this.findViewById(R.id.layout_game_download);
            this.layoutGameName.setOnClickListener(this.onClickListener);
            this.layoutDownload.setOnClickListener(this.onClickListener);
            this.btnCategoryName.setOnClickListener(this.onClickListener);
            this.isEncrypted = true;
            this.adItems = this.model.getAdItems();
            this.adsPagerAdapter = new Type24PagerAdapter(this.adItems, this.isEncrypted, this);
            this.viewPager.setAdapter(this.adsPagerAdapter);
            this.layoutIndicators = (MobileIndicator)this.findViewById(R.id.layout_indicators);
            this.layoutIndicators.setViewPager(this.viewPager);
            View.OnClickListener onClickCloseListener = new View.OnClickListener(){

                public void onClick(View v) {
                    Type_2_4_Dialog.this.dismiss();
                }
            };
            this.rootView.setOnTouchListener(new View.OnTouchListener(){

                @SuppressLint(value={"ClickableViewAccessibility"})
                public boolean onTouch(View view, MotionEvent event) {
                    Type_2_4_Dialog.this.gestureDetector.onTouchEvent(event);
                    return true;
                }
            });
            this.initCoin_NameGame();
            this.btnClose.setOnClickListener(onClickCloseListener);
            int oRientation = DeviceUtils.getScreenOrientation((Context)this.activity);
            if (oRientation == 2 && this.txtDownload != null && this.adItems.get(0).getCoin() != 0) {
                int paddingRight = Utils.dpToPx((Context)this.activity, 20);
                this.txtDownload.setPadding(0, 0, paddingRight, 0);
            }
            if (this.model.getAutoSlideTime() > 0) {
                this.viewPager.setInterval(this.model.getAutoSlideTime());
                this.viewPager.startAutoScroll();
            }
            this.viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

                public void onPageSelected(int position) {
                    Type_2_4_Dialog.this.updateFeatureTitle(position);
                }

                public void onPageScrolled(int arg0, float arg1, int arg2) {
                }

                public void onPageScrollStateChanged(int arg0) {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initCoin_NameGame() {
        try {
            boolean isTablet = this.activity.getResources().getBoolean(R.bool.isTablet);
            String title = isTablet ? this.adItems.get(0).getTitle() : Utils.splitString(this.adItems.get(0).getTitle());
            this.txtNameGame.setText((CharSequence)title);
            if (this.adItems.get(0).getCoin() > 0) {
                this.txtCoin.setVisibility(0);
                this.txtCoin.setText((CharSequence)("+" + this.adItems.get(0).getCoin()));
            } else {
                this.txtCoin.setVisibility(4);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateFeatureTitle(int index) {
        try {
            for (int i = 0; i < this.adItems.size(); ++i) {
                if (i != index) continue;
                boolean isTablet = this.activity.getResources().getBoolean(R.bool.isTablet);
                String title = isTablet ? this.adItems.get(0).getTitle() : Utils.splitString(this.adItems.get(0).getTitle());
                this.txtNameGame.setText((CharSequence)title);
                if (this.adItems.get(0).getCoin() > 0) {
                    this.txtCoin.setVisibility(0);
                    this.txtCoin.setText((CharSequence)("+" + this.adItems.get(0).getCoin()));
                    continue;
                }
                this.txtCoin.setVisibility(4);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void show() {
        super.show();
        try {
            MAdItem adItem = this.adItems.get(0);
            if (adItem == null) {
                return;
            }
            byte[] bytes = adItem.getBannerData();
            int oRientation = DeviceUtils.getScreenOrientation((Context)this.activity);
            float[] optimalSize = GifUtils.loadBytesToGifImage((Context)this.activity, bytes, null, oRientation == 2);
            ViewGroup.LayoutParams lp = this.viewPager.getLayoutParams();
            lp.width = (int)optimalSize[0];
            lp.height = (int)optimalSize[1];
            if (lp.width <= 0) {
                return;
            }
            this.viewPager.setLayoutParams(lp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

