/*
 * Decompiled with CFR 0.152.
 */
package com.leafready.ads.adapters;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.leafready.ads.R;
import com.leafready.ads.dialogs.BaseDialog;
import com.leafready.ads.dialogs.Type5Dialog;
import com.leafready.ads.models.MAdItem;
import com.leafready.ads.utils.DeviceUtils;
import com.leafready.ads.utils.GifUtils;
import com.leafready.ads.utils.LogUtils;
import com.leafready.ads.utils.UpdateViewUtils;
import com.leafready.ads.utils.Utils;
import com.leafready.ads.views.MobileImageView;
import java.util.ArrayList;

public class Type5PagerAdapter
extends PagerAdapter {
    private ArrayList<MAdItem> adsItem;
    private boolean isEncrypted;
    private Activity activity;
    private Type5Dialog dialog;

    public Type5PagerAdapter(ArrayList<MAdItem> listItem, boolean isEncrypted, BaseDialog dialog) {
        this.adsItem = listItem;
        this.activity = dialog.getActivity();
        this.dialog = (Type5Dialog)dialog;
        this.isEncrypted = isEncrypted;
    }

    @SuppressLint(value={"ClickableViewAccessibility", "InflateParams"})
    public Object instantiateItem(ViewGroup container, int position) {
        final MAdItem adItem = this.adsItem.get(position);
        View view = LayoutInflater.from((Context)this.activity).inflate(R.layout.dialog_popup_5_item, null);
        LinearLayout layoutGameName = (LinearLayout)view.findViewById(R.id.layout_game_name);
        final MobileImageView bannerImage = (MobileImageView)view.findViewById(R.id.item_imageview);
        TextView txtGameName = (TextView)view.findViewById(R.id.txt_game_name);
        TextView txtCoin = (TextView)view.findViewById(R.id.txt_Mobilecoin);
        Button btnCategoryName = (Button)view.findViewById(R.id.btn_category_game);
        RelativeLayout layoutDownload = (RelativeLayout)view.findViewById(R.id.layout_game_download);
        try {
            boolean isTablet = this.activity.getResources().getBoolean(R.bool.isTablet);
            String title = isTablet ? adItem.getTitle() : Utils.splitString(adItem.getTitle());
            txtGameName.setText((CharSequence)title);
            if (this.adsItem.get(position).getCoin() > 0) {
                txtCoin.setVisibility(0);
                txtCoin.setText((CharSequence)("+" + adItem.getCoin()));
            } else {
                txtCoin.setVisibility(4);
            }
            int oRientation = DeviceUtils.getScreenOrientation((Context)this.activity);
            TextView txtDownload = (TextView)view.findViewById(R.id.txt_download);
            if (oRientation == 2 && adItem.getCoin() != 0 && txtDownload != null) {
                int paddingRight = Utils.dpToPx((Context)this.activity, 20);
                txtDownload.setPadding(0, 0, paddingRight, 0);
            }
            byte[] bytes = adItem.getBannerData();
            layoutDownload.setOnClickListener(this.dialog.onClickListener);
            layoutGameName.setOnClickListener(this.dialog.onClickListener);
            btnCategoryName.setOnClickListener(this.dialog.onClickListener);
            GifUtils.loadBytesToGifImage((Context)this.activity, bytes, bannerImage, true);
            bannerImage.setViewListener(new MobileImageView.ImageViewListener(){

                @Override
                public void onClick(View view) {
                    Type5PagerAdapter.this.dialog.onClickHandler(adItem);
                }

                @Override
                public void onLongPress(View view) {
                }

                @Override
                public void onScroll() {
                }

                @Override
                public void onHold() {
                }

                @Override
                public void onHoldRelease() {
                }
            });
            ((ViewPager)container).addView(view);
            UpdateViewUtils.updatWhenViewTreeLoaded((Context)this.activity, view, new UpdateViewUtils.ViewTreeListener(){

                @Override
                public void done() {
                    Drawable drawable = bannerImage.getDrawable();
                    Rect bounds = drawable.getBounds();
                    int width = bounds.width();
                    ((Type5PagerAdapter)Type5PagerAdapter.this).dialog.pagerPadding = (int)((double)(DeviceUtils.getScreenWidthInPixels((Context)Type5PagerAdapter.this.activity) - width) / 2.5);
                    LogUtils.log((Context)Type5PagerAdapter.this.activity, "image size", "" + width);
                    Type5PagerAdapter.this.dialog.updatePadding();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return view;
    }

    public MAdItem getCurrentItem(int position) {
        try {
            return this.adsItem.get(position);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new MAdItem();
        }
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        try {
            container.removeView((View)object);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getCount() {
        try {
            return this.adsItem.size();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean isViewFromObject(View view, Object object) {
        try {
            return view == object;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

