/*
 * Decompiled with CFR 0.152.
 */
package com.leafready.ads;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.InterstitialAd;
import com.leafready.ads.AbstractAd;
import com.leafready.ads.dialogs.Type5Dialog;
import com.leafready.ads.dialogs.Type_1_3_Dialog;
import com.leafready.ads.dialogs.Type_2_4_Dialog;
import com.leafready.ads.models.MAd;
import com.leafready.ads.models.MAdItem;
import com.leafready.ads.utils.DeviceUtils;
import com.leafready.ads.utils.GifUtils;
import com.leafready.ads.utils.LogUtils;
import com.leafready.ads.utils.NetUtils;
import com.leafready.ads.utils.Utils;
import com.leafready.ads.views.GifImageView;
import java.util.ArrayList;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class PopupAd
extends AbstractAd {
    private static final String TAG = PopupAd.class.getSimpleName();
    private boolean debugMode = false;
    private Activity activity;
    private InterstitialAd mInterstitialAd;
    private Dialog dialog;
    private MAd model;
    private int countLoadedBanners;
    private String apiDebugUrl;
    private Callback<ResponseBody> mResultListener = new Callback<ResponseBody>(){
        private String jsonStr;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onResponse(Call<ResponseBody> caller, Response<ResponseBody> response) {
            try {
                this.jsonStr = ((ResponseBody)response.body()).string();
                LogUtils.log((Context)PopupAd.this.activity, TAG, "onPostExecute:" + this.jsonStr);
                PopupAd.this.model = new MAd(this.jsonStr);
                switch (PopupAd.this.model.getStatus()) {
                    case 1: {
                        PopupAd.this.countLoadedBanners = 0;
                        for (int i = 0; i < PopupAd.this.model.getAdItems().size() && PopupAd.this.adStatus != AbstractAd.Status.ERROR; ++i) {
                            final MAdItem adItem = PopupAd.this.model.getAdItems().get(i);
                            String bannerUrl = adItem.getBannerUrl();
                            Glide.with((Activity)PopupAd.this.activity).as(byte[].class).load(bannerUrl).into((Target)new SimpleTarget<byte[]>(){

                                public void onResourceReady(@NonNull byte[] imageBytesData, @Nullable Transition<? super byte[]> transition) {
                                    if (imageBytesData == null) {
                                        PopupAd.this.adStatus = AbstractAd.Status.ERROR;
                                        if (PopupAd.this.adListener != null) {
                                            PopupAd.this.adListener.onAdLoadedError(103, "Ad load failed!");
                                        }
                                        return;
                                    }
                                    if (imageBytesData.length <= 0) {
                                        PopupAd.this.adStatus = AbstractAd.Status.ERROR;
                                        if (PopupAd.this.adListener != null) {
                                            PopupAd.this.adListener.onAdLoadedError(103, "Ad load failed!");
                                        }
                                        return;
                                    }
                                    adItem.setBannerData(imageBytesData);
                                    PopupAd.this.countLoadedBanners++;
                                    if (PopupAd.this.countLoadedBanners == PopupAd.this.model.getAdItems().size()) {
                                        PopupAd.this.adStatus = AbstractAd.Status.LOADED;
                                        if (PopupAd.this.adListener != null) {
                                            PopupAd.this.adListener.onAdLoaded();
                                        }
                                    } else if (PopupAd.this.countLoadedBanners >= 1) {
                                        PopupAd.this.adStatus = AbstractAd.Status.PARTIAL_LOADED;
                                    }
                                }

                                public void onLoadFailed(Exception e, Drawable errorDrawable) {
                                    PopupAd.this.adStatus = AbstractAd.Status.ERROR;
                                    if (PopupAd.this.adListener != null) {
                                        PopupAd.this.adListener.onAdLoadedError(103, "Ad load failed!");
                                    }
                                }
                            });
                        }
                        return;
                    }
                    case 2: {
                        PopupAd.this.initAdmob(PopupAd.this.activity, PopupAd.this.model.getPubKeyAdmob());
                        PopupAd.this.loadAdmob();
                        return;
                    }
                    default: {
                        PopupAd.this.adStatus = AbstractAd.Status.ERROR;
                        if (PopupAd.this.adListener == null) return;
                        String message = "Error!!!";
                        if (PopupAd.this.model.hasError()) {
                            message = PopupAd.this.model.getError();
                        }
                        PopupAd.this.adListener.onAdLoadedError(103, message);
                    }
                }
                return;
            }
            catch (Exception e) {
                PopupAd.this.adStatus = AbstractAd.Status.ERROR;
                if (PopupAd.this.adListener == null) return;
                PopupAd.this.adListener.onAdLoadedError(101, e.getMessage());
            }
        }

        public void onFailure(Call<ResponseBody> arg0, Throwable error) {
            try {
                PopupAd.this.adStatus = AbstractAd.Status.ERROR;
                if (PopupAd.this.adListener != null) {
                    PopupAd.this.adListener.onAdLoadedError(101, error.getMessage());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public PopupAd(Activity activity) {
        this.activity = activity;
        DeviceUtils.saveMarResolution((Context)activity);
    }

    public void enableDebug(boolean enable) {
        this.debugMode = enable;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setApiDebugUrl(String apiUrl) {
        this.apiDebugUrl = apiUrl;
    }

    @Override
    public void loadAd() {
        block8: {
            try {
                Log.i((String)TAG, (String)"loadAd");
                if (!this.isLoading() && Utils.isNetworkAvailable((Context)this.activity)) {
                    try {
                        this.adStatus = AbstractAd.Status.LOADING;
                        if (this.debugMode) {
                            NetUtils.getAsyc((Context)this.activity, this.apiDebugUrl, this.mResultListener, true);
                            break block8;
                        }
                        NetUtils.getAsyc((Context)this.activity, "http://kasinr.fltinhalq.com/api/LeafReadyPop", this.mResultListener, true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.adStatus = AbstractAd.Status.ERROR;
                        if (this.adListener != null) {
                            this.adListener.onAdLoadedError(100, "Connection error");
                        }
                        break block8;
                    }
                }
                this.adStatus = AbstractAd.Status.ERROR;
                if (this.adListener != null) {
                    this.adListener.onAdLoadedError(100, "Connection error");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void show() {
        try {
            if (!Utils.isNetworkAvailable((Context)this.activity)) {
                this.adStatus = AbstractAd.Status.ERROR;
                if (this.adListener != null) {
                    this.adListener.onAdLoadedError(100, "please check your network!");
                }
                return;
            }
            if (this.model == null) {
                this.adStatus = AbstractAd.Status.ERROR;
                if (this.adListener != null) {
                    this.adListener.onAdLoadedError(101, "Double loaded , again!!");
                }
                return;
            }
            if (this.model.getStatus() == 2) {
                this.showAdmob();
            } else if (this.model.getStatus() == 1) {
                if (this.isLoaded() && !this.isShowing()) {
                    this.doShow();
                }
            } else {
                this.adStatus = AbstractAd.Status.ERROR;
                if (this.adListener != null) {
                    this.adListener.onAdLoadedError(100, "Connection error");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.adStatus = AbstractAd.Status.ERROR;
            if (this.adListener != null) {
                this.adListener.onAdLoadedError(103, "Ad load failed!");
            }
            return;
        }
    }

    @Override
    protected boolean isShowing() {
        try {
            return this.dialog != null && this.dialog.isShowing();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected void close() {
        try {
            if (this.dialog != null) {
                this.dialog.dismiss();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doShow() {
        try {
            switch (this.model.getPopupType()) {
                case 1: {
                    this.dialog = new Type_1_3_Dialog(this.activity, this.model);
                    break;
                }
                case 2: {
                    this.dialog = new Type_2_4_Dialog(this.activity, this.model);
                    break;
                }
                case 3: {
                    this.dialog = new Type_1_3_Dialog(this.activity, this.model);
                    break;
                }
                case 4: {
                    this.dialog = new Type_2_4_Dialog(this.activity, this.model);
                    break;
                }
                case 5: {
                    this.dialog = new Type5Dialog(this.activity, this.model);
                }
            }
            if (this.dialog == null) {
                this.adStatus = AbstractAd.Status.ERROR;
                if (this.adListener != null) {
                    this.adListener.onAdLoadedError(101, "Ad load failed!");
                }
                return;
            }
            this.dialog.setOnShowListener(new DialogInterface.OnShowListener(){

                public void onShow(DialogInterface dialog) {
                    if (PopupAd.this.adListener != null) {
                        PopupAd.this.adListener.onAdOpened();
                        try {
                            NetUtils.postAsyc((Context)PopupAd.this.activity, PopupAd.this.model.getShowAdsUrl(), true);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            this.dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialog) {
                    if (PopupAd.this.adListener != null) {
                        PopupAd.this.adListener.onAdClosed();
                    }
                }
            });
            this.dialog.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    void loadBytesToGifImageView(Activity a, byte[] bytes, GifImageView imageView) {
        try {
            if (!GifUtils.isGif(bytes)) {
                Bitmap bitmap = Utils.getBitmapfromBytes(bytes);
                float[] resizeImage = Utils.getProperSizeForIntertitialImage((Context)a, bitmap);
                Bitmap newBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)resizeImage[0]), (int)((int)resizeImage[1]), (boolean)true);
                imageView.setImageBitmap(newBitmap);
            } else {
                imageView.setBytes(bytes);
                imageView.startAnimation();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initAdmob(Activity activity, String admobUnitId) {
        try {
            this.mInterstitialAd = new InterstitialAd((Context)activity);
            this.mInterstitialAd.setAdUnitId(admobUnitId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadAdmob() {
        try {
            if (this.mInterstitialAd != null && !this.mInterstitialAd.isLoaded()) {
                AdRequest adRequest = new AdRequest.Builder().build();
                this.adStatus = AbstractAd.Status.LOADING;
                this.mInterstitialAd.setAdListener(new AdListener(){

                    public void onAdFailedToLoad(int errorCode) {
                        super.onAdFailedToLoad(errorCode);
                        PopupAd.this.adStatus = AbstractAd.Status.ERROR;
                        if (PopupAd.this.adListener != null) {
                            PopupAd.this.adListener.onAdLoadedError(errorCode, "Admob error");
                        }
                    }

                    public void onAdLoaded() {
                        super.onAdLoaded();
                        PopupAd.this.adStatus = AbstractAd.Status.LOADED;
                        if (PopupAd.this.adListener != null) {
                            PopupAd.this.adListener.onAdLoaded();
                        }
                    }

                    public void onAdOpened() {
                        super.onAdOpened();
                        if (PopupAd.this.adListener != null) {
                            PopupAd.this.adListener.onAdOpened();
                        }
                    }

                    public void onAdClosed() {
                        super.onAdClosed();
                        if (PopupAd.this.adListener != null) {
                            PopupAd.this.adListener.onAdClosed();
                        }
                    }
                });
                this.mInterstitialAd.loadAd(adRequest);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showAdmob() {
        try {
            if (this.mInterstitialAd != null && this.mInterstitialAd.isLoaded()) {
                this.mInterstitialAd.show();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList<String> getListImageUrl() {
        ArrayList<String> images = new ArrayList<String>();
        try {
            for (MAdItem adItem : this.model.getAdItems()) {
                images.add(adItem.getBannerUrl());
            }
            return images;
        }
        catch (Exception e) {
            e.printStackTrace();
            return images;
        }
    }
}

