package com.leafready.ads.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageButton;
import android.widget.ImageView.ScaleType;
import android.widget.LinearLayout;

import com.leafready.ads.R;

public class MobileIndicator extends LinearLayout {
	private SparseArray<ImageButton> btnIndicators;
	private LinearLayout layoutIndicators;
	private String TAG = MobileIndicator.this.getClass().getSimpleName();
	private boolean init = false;
	private View rootView;
	private ViewPager mViewPager;
	public MobileIndicator(Context context, AttributeSet attrs) {
		super(context, attrs);
		init(context);
	}

	/**
	 * @param context
	 */
	@SuppressLint("InflateParams")
	private void init(Context context) {
		try {
			this.setIndicatorContext(context);
			if (init) {
				return;
			}

			rootView = LayoutInflater.from(context).inflate(
					R.layout.indicator_view, null);

			layoutIndicators = (LinearLayout) rootView.findViewById(R.id.indicator);

			this.addView(rootView);
			init = true;
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	public void initialize() {
		try {
			Log.d(TAG, "number of indicator: " + numberOfItem);
			if (this.numberOfItem <= 1) {
				this.setVisibility(View.GONE);
				return;
			}
			btnIndicators = new SparseArray<ImageButton>();
			for (int i = 0; i < this.numberOfItem; i++) {
				float density = this.getDensity(indicatorContext);
				int padding = (int) (4 * density);
				ImageButton btnIndicator = new ImageButton(indicatorContext);
				btnIndicator.setLayoutParams(new LayoutParams(
						LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT));
				if (i == 0) {
					btnIndicator.setImageResource(R.drawable.indicator_white);
				} else {
					btnIndicator.setImageResource(R.drawable.indicator_inactive);
				}
				btnIndicator.setBackgroundResource(0);
				btnIndicator.setScaleType(ScaleType.FIT_XY);
				btnIndicator.setPadding(padding, 0, padding, 0);
				layoutIndicators.addView(btnIndicator);
				btnIndicators.put(i, btnIndicator);
			}

			this.setVisibility(View.VISIBLE);
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	public void updatePosition(int index) {
		try {
			if(btnIndicators == null){
				return;
			}
			int itemSize = btnIndicators.size();
			for (int i = 0; i < itemSize; i++) {
				if (i == index) {
					btnIndicators.get(i).setImageResource(
							R.drawable.indicator_white);
				} else {
					btnIndicators.get(i).setImageResource(
							R.drawable.indicator_inactive);
				}
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	private float getDensity(Context context) {
		try {
			return context.getResources().getDisplayMetrics().density;
		}catch (Exception e){
			e.printStackTrace();
			return 0;
		}
	}

	private int numberOfItem;

	public MobileIndicator setNumberOfItem(int numberOfItem) {
		this.numberOfItem = numberOfItem;
		return this;
	}

	public MobileIndicator setViewPager(ViewPager mViewpager) {
		try {
			this.mViewPager = mViewpager;
			if (mViewpager != null && mViewpager.getAdapter() != null) {
				this.numberOfItem = mViewPager.getAdapter().getCount();
			}
			mViewPager.addOnPageChangeListener(mInternalPageChangeListener);
			initialize();
		}catch (Exception e){
			e.printStackTrace();
		}
		return this;
	}

	private final ViewPager.OnPageChangeListener mInternalPageChangeListener = new ViewPager.OnPageChangeListener() {
		@Override
		public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
			try {
				if (mViewPager.getAdapter() == null || mViewPager.getAdapter().getCount() <= 0) {
					return;
				}
				else {
					updatePosition(position);
				}
			}catch (Exception e){
				e.printStackTrace();
			}
		}

		@Override
		public void onPageSelected(int position) {

		}

		@Override
		public void onPageScrollStateChanged(int state) {

		}
	};


	public int getNumberOfItem() {
		return this.numberOfItem;
	}

	private Context indicatorContext;

	public Context getIndicatorContext() {
		return indicatorContext;
	}

	public void setIndicatorContext(Context indicatorContext) {
		this.indicatorContext = indicatorContext;
	}

}
