package com.leafready.ads.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;

public class MobileImageView extends GifImageView implements
		GestureDetector.OnGestureListener {
	private final String TAG = MobileImageView.this.getClass().getSimpleName();

	public interface ImageViewListener {
		void onClick(View view);
		void onLongPress(View view);
		void onScroll();
		void onHold();
		void onHoldRelease();
	}

	private GestureDetector gestureScanner;

	public GestureDetector getGestureDetector(){
		return this.gestureScanner;
	}
	private ImageViewListener listener;

	public void setViewListener(ImageViewListener listener) {
		this.listener = listener;
	}

	public MobileImageView(Context context, AttributeSet attrs) {
		super(context, attrs);
		this.init(context);

	}

	@SuppressLint("ClickableViewAccessibility")
	private void init(Context context) {
		this.gestureScanner = new GestureDetector(getContext(), this);
		//capture touch event for gesture scanner
		setOnTouchListener(new OnTouchListener() {

			@Override
			public boolean onTouch(View view, MotionEvent event) {
				try {
					if(event.getAction() != MotionEvent.ACTION_UP){
						if(listener != null){
							listener.onHold();
						}
					}else{
						if(listener != null){
							listener.onHoldRelease();
						}
					}
					return true;
				}catch (Exception e){
					e.printStackTrace();
					return false;
				}
			}
		});
	}

	@Override
	public boolean dispatchTouchEvent(MotionEvent event) {
		boolean dispatch = super.dispatchTouchEvent(event);
		this.gestureScanner.onTouchEvent(event);
		return dispatch;
	}

	@Override
	public boolean onDown(MotionEvent arg0) {
		return true;
	}

	@Override
	public boolean onFling(MotionEvent arg0, MotionEvent arg1, float arg2,
                           float arg3) {
		return false;
	}

	@Override
	public void onLongPress(MotionEvent event) {
		try {
			listener.onLongPress(this);
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	@Override
	public boolean onScroll(MotionEvent arg0, MotionEvent arg1, float arg2,
                            float arg3) {
		try {
			listener.onScroll();
			return false;
		}catch (Exception e){
			e.printStackTrace();
			return false;
		}
	}

	@Override
	public void onShowPress(MotionEvent arg0) {

	}

	@Override
	public boolean onSingleTapUp(MotionEvent event) {
		try {
			Log.d(TAG, "SINGLE tap detected!");
			listener.onClick(this);
			return true;
		}catch (Exception e){
			e.printStackTrace();
			return false;
		}
	}

}
