package com.leafready.ads.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;

public class MobileFrameLayout extends FrameLayout implements
		GestureDetector.OnGestureListener {
	public interface MobileFrameLayoutListener {
		void onClick(View view);

		void onLongPress(View view);
	}

	private GestureDetector gestureScanner;

	private MobileFrameLayoutListener listener;

	public void setViewListener(MobileFrameLayoutListener listener) {
		this.listener = listener;
	}

	public MobileFrameLayout(Context context, AttributeSet attrs) {
		super(context, attrs);
		this.init(context);

	}

	@SuppressLint("ClickableViewAccessibility")
	private void init(Context context) {
		this.gestureScanner = new GestureDetector(getContext(), this);
		// capture touch event for gesture scanner
		setOnTouchListener(new OnTouchListener() {

			@Override
			public boolean onTouch(View arg0, MotionEvent arg1) {
				return true;
			}
		});
	}

	@Override
	public boolean dispatchTouchEvent(MotionEvent event) {
		this.gestureScanner.onTouchEvent(event);
		return super.dispatchTouchEvent(event);
	}

	@Override
	public boolean onDown(MotionEvent arg0) {
		return false;
	}

	@Override
	public boolean onFling(MotionEvent arg0, MotionEvent arg1, float arg2,
                           float arg3) {
		return false;
	}

	@Override
	public void onLongPress(MotionEvent arg0) {

	}

	@Override
	public boolean onScroll(MotionEvent arg0, MotionEvent arg1, float arg2,
                            float arg3) {
		return false;
	}

	@Override
	public void onShowPress(MotionEvent arg0) {

	}

	@Override
	public boolean onSingleTapUp(MotionEvent arg0) {
		listener.onClick(this);
		return false;
	}
}
