package com.leafready.ads.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.util.Base64;
import android.util.Log;

import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PackageUtils {

    public static boolean isCameraSupport(Context context) {
        PackageManager pm = context.getPackageManager();
        return pm.hasSystemFeature(PackageManager.FEATURE_CAMERA);
    }

    public static String getAppVersionName(Context context) {
        try {
            PackageInfo pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return pInfo.versionName;
        } catch (Exception exception) {
            return "";
        }
    }

    public static int getAppBuildNumber(Context context) {
        try {
            PackageInfo pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return pInfo.versionCode;
        } catch (Exception exception) {
            return 0;
        }
    }

    public static long getFirstInstallTime(Context context) {
        try {
            return getFirstInstallTime(context, context.getPackageName());
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return 0L;
    }

    public static long getFirstInstallTime(Context context, String packageName) throws PackageManager.NameNotFoundException {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(packageName, 0);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.GINGERBREAD) {
                return packageInfo.firstInstallTime;
            } else {
                return new File(packageInfo.applicationInfo.sourceDir).lastModified();
            }
        }catch (Exception e){
            e.printStackTrace();
            return 0;
        }
    }

    public static List<ApplicationInfo> getInstalledApplicationInfos(Context context) {
        List<ApplicationInfo> allApplicationInfos = context.getPackageManager().getInstalledApplications(PackageManager.GET_META_DATA);
        List<ApplicationInfo> applicationInfos = new ArrayList<ApplicationInfo>();
        for (ApplicationInfo applicationInfo : allApplicationInfos) {
            if ((applicationInfo.flags & ApplicationInfo.FLAG_SYSTEM) != 0) {
                continue;
            }
            applicationInfos.add(applicationInfo);
        }
        return applicationInfos;
    }

    public static boolean checkGrantedPermissions(Context context, String grantedPermission) {
        return checkGrantedPermissions(context, Arrays.asList(grantedPermission));
    }

    public static boolean checkGrantedPermissions(Context context, String... grantedPermissions) {
        return checkGrantedPermissions(context, Arrays.asList(grantedPermissions));
    }

    public static boolean checkGrantedPermissions(Context context, List<String> grantedPermissions) {
        try {
            for (String permission : grantedPermissions) {
                if (context.checkCallingOrSelfPermission(permission) != PackageManager.PERMISSION_GRANTED) {
                    return false;
                }
            }
        }catch (Exception e){
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean isPackageInstalled(Context context, String packageName) {
        try {
            context.getPackageManager().getApplicationInfo(packageName, 0);
            return true;
        } catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static boolean isSystemApp(Context context, String packageName) throws PackageManager.NameNotFoundException {
        ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(packageName, 0);
        return ((applicationInfo.flags & ApplicationInfo.FLAG_SYSTEM) != 0);
    }

    public static String getSignature(Context context, String packageName) {
        PackageInfo info;
        try {
            info = context.getPackageManager().getPackageInfo(packageName, PackageManager.GET_SIGNATURES);
            for (Signature signature : info.signatures) {
                MessageDigest md;
                md = MessageDigest.getInstance("SHA");
                md.update(signature.toByteArray());
                String something = new String(Base64.encode(md.digest(), 0));
                Log.e("hash key", something);
                return something;
            }
        } catch (PackageManager.NameNotFoundException e1) {
            Log.e("name not found", e1.toString());
        } catch (NoSuchAlgorithmException e) {
            Log.e("no such an algorithm", e.toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static boolean isUserApp(Context context, String packageName) throws PackageManager.NameNotFoundException {
        return !isSystemApp(context, packageName);
    }

}
