package com.leafready.ads.utils;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;

import com.leafready.ads.AdsManager;

import org.json.JSONObject;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.QueryMap;
import retrofit2.http.Url;

public class NetService {
    private boolean encryptEnable = false;

    private static NetService INSTANCE;
    private final Context context;

    interface BaseService {
        @POST
        Call<ResponseBody> post(@Url String url,
                                @QueryMap HashMap<String, String> postParameters);

        @POST
        Call<ResponseBody> post(@Url String url);

        @PUT
        Call<ResponseBody> put(@Url String url,
                               @QueryMap HashMap<String, String> putParameters);

        @GET
        Call<ResponseBody> get(@Url String url);
    }

    public NetService(Context context) {
        this.context = context;
    }

    public static NetService getInstance(Context context) {
        if (INSTANCE == null) {
            return new NetService(context);
        }
        return INSTANCE;
    }

    public BaseService getRequestService() {
        try{
            OkHttpClient.Builder builder = new OkHttpClient.Builder().readTimeout(
                    20, TimeUnit.SECONDS).connectTimeout(30, TimeUnit.SECONDS);
            HttpInterceptor httpInterceptor = new HttpInterceptor(context);
            httpInterceptor.encryptEnable = encryptEnable;
            builder.addInterceptor(httpInterceptor);
            if (DebugConfigs.isDebugEnable(context)) {
                HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
                interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
                builder.addInterceptor(interceptor);
            }
            OkHttpClient defaultHttpClient = builder.build();
            Retrofit retrofit = new Retrofit.Builder()
                    .baseUrl(Constants.DOMAIN).client(defaultHttpClient)
                    .build();

            return retrofit.create(BaseService.class);
        }catch (Exception e){
            e.printStackTrace();
            return new Retrofit.Builder().baseUrl(Constants.DOMAIN).build().create(BaseService.class);
        }
    }

    public NetService encryptEnable(boolean enable) {
        encryptEnable = enable;
        return this;
    }

    static class HttpInterceptor implements Interceptor {

        private static final String TAG = "HttpInterceptor";
        private Context mContext;
        private boolean encryptEnable = false;

        public HttpInterceptor(Context context) {
            this.mContext = context;
        }

        @Override
        public Response intercept(Chain chain) throws IOException {
            Request.Builder requestBuilder = chain.request().newBuilder();
           try{
               String advertisingId = Utils.getAdvertisingID(mContext);
               if (advertisingId != null) {
                   requestBuilder.addHeader(Constants.ADVER_ID, advertisingId);
               }
               if (AdsManager.getApiKey() != null) {
                   requestBuilder.addHeader(Constants.KEY_API, AdsManager.getApiKey());
               }
               requestBuilder.addHeader(Constants.OS_HEJDIEUFHANHF,
                       Utils.getVersionOS(mContext));
               requestBuilder.addHeader(Constants.KIEUR_MANGJ,
                       Utils.getNetworkType(mContext));
               requestBuilder.addHeader(Constants.LOG_NGONNGUX,
                       Utils.getLanguage(mContext));
//            String PY_CHIEUFTHIETSBI = DeviceUtils
//                    .getRealScreenWidthInPixels(mContext)
//                    + "-"
//                    + DeviceUtils.getRealScreenHeightInPixels(mContext)
//                    + "-"
//                    + DeviceUtils.getScreenOrientation(mContext);
               String LOG_CHIEUFTHIETSBI = DeviceUtils.getMarResolution(mContext);
               Log.d(TAG, "resolution : " + LOG_CHIEUFTHIETSBI);

               requestBuilder
                       .addHeader(Constants.LOG_CHIEUFTHIETSBI, LOG_CHIEUFTHIETSBI);
               requestBuilder.addHeader(Constants.LOG_PHIENBANR_SDK,
                       Constants.SDK_VERSION);
               if (AdsManager.getUserId() != null) {
                   requestBuilder.addHeader(Constants.ID_NGUOIFDUNG, AdsManager.getUserId());
               }

               if ("post".equalsIgnoreCase(chain.request().method())) {
                   if (AdsManager.getUserId() != null && Utils.getPackageName(mContext) != null) {
                       requestBuilder.addHeader(Constants.ID_NGUOIFDUNG,
                               AdsManager.getUserId());
                       requestBuilder.addHeader(Constants.LOG_TEN_GOIS,
                               Utils.getPackageName(mContext));
                   }
               }

               if (encryptEnable) {
                   String url = chain.request().url().toString();
                   Uri uri = Uri.parse(url);
                   if (uri.getQueryParameter("sign") == null) {
                       url = uri
                               .buildUpon()
                               .appendQueryParameter("sign",
                                       EncryptionUtils.getSignString(mContext))
                               .build().toString();
                   }
                   requestBuilder.url(url);
               }
           }catch (Exception e){
               e.printStackTrace();
           }
            Request request = requestBuilder.build();
            Log.i(TAG, "Request URL: " + request.url());

            Response response = chain.proceed(request);
            try {
                String responseStringData = response.body().string();
                MediaType contentType = response.body().contentType();

                if (!TextUtils.isEmpty(responseStringData) && encryptEnable
                        && !isJsonString(responseStringData)) {
                    try {
                        String convertHex2Accii = EncryptionUtils
                                .hexToASCII(responseStringData);
                        byte[] decodeFromBase64 = Base64.decode(convertHex2Accii,
                                Base64.DEFAULT);
                        responseStringData = EncryptionUtils
                                .decrytionDataBlowfish(decodeFromBase64);

                    } catch (NumberFormatException numberFormatException) {
                        LogUtils.loge(mContext, numberFormatException);
                    } catch (Exception exception) {
                        LogUtils.loge(mContext, exception);
                    }
                }

                if (!TextUtils.isEmpty(responseStringData)) {
                    ResponseBody body = ResponseBody.create(contentType,
                            responseStringData);
                    return response.newBuilder().body(body).build();
                }
            }catch (Exception e){
                e.printStackTrace();
            }

            return response;
        }

        private boolean isJsonString(String jsonString) {
            try {
                new JSONObject(jsonString);
                return true;
            } catch (Exception exception) {
                return false;
            }
        }
    }
}
