package com.leafready.ads.utils;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;

public class LogUtils {
	private enum LogType{
		DEBUG, EXCEPTION
	}

	public static void loge(Context context, String message) {
		loge(context, "", message);
	}

	public static void loge(Context context, String tag, String message) {
		if (DebugConfigs.isDebugEnable(context)) {
			logHandler(context, tag, message, LogType.EXCEPTION);
		}
	}

	public static void loge(Context context, String tag, Exception exception) {
		if (DebugConfigs.isDebugEnable(context)) {
			logHandler(context, tag, exception.getMessage(), LogType.EXCEPTION);
			exception.printStackTrace();
		}
	}
	
	public static void loge(Context context, Exception exception) {
		loge(context, "", exception.getMessage());
	}

	public static void showToast(Context context, String message) {
		if (DebugConfigs.isDebugEnable(context)) {
			Toast.makeText(context, message, Toast.LENGTH_SHORT).show();
		}
	}

	public static void log(Context context, String tag, String message) {
		if (DebugConfigs.isDebugEnable(context)) {
			logHandler(context, tag, message, LogType.DEBUG);
		}
	}
	
	public static void log(Context context, String message) {
		log(context, "", message);
	}

	private static void logHandler(Context context, String tag, String message, LogType logType) {
		try {
			String fullClassName = Thread.currentThread().getStackTrace()[3]
					.getClassName();
			String className = fullClassName.substring(fullClassName
					.lastIndexOf(".") + 1);
			if (className.contains("$")) {
				className = className.substring(0, className.lastIndexOf("$"));
			}
			String methodName = Thread.currentThread().getStackTrace()[3]
					.getMethodName();
			int lineNumber = Thread.currentThread().getStackTrace()[3]
					.getLineNumber();

			String tagDebug = DebugConfigs.getTag(context);
			if (!TextUtils.isEmpty(tag)) {
				tagDebug = tag;
			}

			String logMessage = "at (" + className + ".java:" + lineNumber + ") " + "["
					+ methodName + "]" + message;
			if(logType == LogType.EXCEPTION){
				Log.e(tagDebug, logMessage);
				return;
			}
			Log.d(tagDebug, logMessage);
		}catch (Exception e){
			e.printStackTrace();
		}
	}
}
