package com.leafready.ads.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.util.Log;

import com.leafready.ads.views.MobileImageView;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class GifUtils {

	private static final float BLUR_RADIUS = 25f;

	private static RenderScript rs;
	private static ScriptIntrinsicBlur script;
	private static Allocation input;
	private static Allocation output;
	private static boolean configured = false;
	private static Bitmap tmp = null;
	private static int[] pixels = null;
	
	public static boolean isGif(byte[] data) {
		if (data != null) {
			try {
				// Initialiaze the raw data buffer
				ByteBuffer rawData = ByteBuffer.wrap(data);
				rawData.rewind();
				rawData.order(ByteOrder.LITTLE_ENDIAN);

				String id = "";
				for (int i = 0; i < 6; i++) {
					int curByte = 0;
					try {
						curByte = (rawData.get() & 0xFF);
					} catch (Exception e) {}
					id += (char) curByte;
				}
				if (id.startsWith("GIF")) {
					return true;
				}
			}catch (Exception e){
				e.printStackTrace();
				return false;
			}
		}
		return false;
	}

	@SuppressLint("NewApi")
	public static Bitmap blur(Activity activity, Bitmap image) {
		if (image == null)
			return null;
		
		image = RGB565toARGB888(activity, image);
		if (!configured) {
			rs = RenderScript.create(activity);
			input = Allocation.createFromBitmap(rs, image);
			output = Allocation.createTyped(rs, input.getType());
			script = ScriptIntrinsicBlur.create(rs, Element.U8_4(rs));
			script.setRadius(BLUR_RADIUS);
			configured = true;
		} else
			input.copyFrom(image);

		script.setInput(input);
		script.forEach(output);
		output.copyTo(image);

		return image;
	}

	@SuppressLint("NewApi")
	public static Bitmap blur(Activity activity, Bitmap image, int widthInPixel, int heightInPixel) {
		try {
			if (image == null)
				return null;

			image = RGB565toARGB888(activity, image, widthInPixel, heightInPixel);
			if (!configured) {
				rs = RenderScript.create(activity);
				input = Allocation.createFromBitmap(rs, image);
				output = Allocation.createTyped(rs, input.getType());
				script = ScriptIntrinsicBlur.create(rs, Element.U8_4(rs));
				script.setRadius(BLUR_RADIUS);
				configured = true;
			} else
				input.copyFrom(image);

			script.setInput(input);
			script.forEach(output);
			output.copyTo(image);

			return image;
		}catch (Exception e){
			e.printStackTrace();
			Bitmap bitmap = Bitmap.createBitmap(100, 100, Bitmap.Config.ARGB_8888);
			bitmap.eraseColor(Color.WHITE);
			return bitmap;
		}
	}

	private static Bitmap RGB565toARGB888(Activity activity, Bitmap img) {
		// Create a Bitmap of the appropriate format.
		try {
			int numPixels = img.getWidth() * img.getHeight();
			if (tmp == null) {
				tmp = Bitmap.createBitmap(img.getWidth(), img.getHeight(),
						Bitmap.Config.ARGB_8888);
				Log.i("TAG Blur", "width:" + img.getWidth() + ", heght:" + img.getHeight());
				pixels = new int[numPixels];
			}
			// Get JPEG pixels. Each int is the color values for one pixel.
			img.getPixels(pixels, 0, img.getWidth(), 0, 0,
					img.getWidth(), img.getHeight());
			// Set RGB pixels.
			tmp.setPixels(pixels, 0, tmp.getWidth(), 0, 0,
					tmp.getWidth(), tmp.getHeight());

			return tmp;
		}catch (Exception e){
			e.printStackTrace();
			Bitmap bitmap = Bitmap.createBitmap(100, 100, Bitmap.Config.ARGB_8888);
			bitmap.eraseColor(Color.WHITE);
			return bitmap;
		}
	}
	
	public static Bitmap RGB565toARGB888(Activity activity, Bitmap image, int widthInPixel, int heightInPixel) {
		try {
			int numPixels = widthInPixel * heightInPixel;
			if (tmp == null) {
				tmp = Bitmap.createBitmap(widthInPixel, heightInPixel,
						Bitmap.Config.ARGB_8888);
				Log.i("TAG Blur", "width:" + image.getWidth() + ", heght:" + image.getHeight());
				pixels = new int[numPixels];
			}
			// Get JPEG pixels. Each int is the color values for one pixel.
			image.getPixels(pixels, 0, image.getWidth(), 0, 0,
					image.getWidth(), image.getHeight());
			// Set RGB pixels.
			tmp.setPixels(pixels, 0, tmp.getWidth(), 0, 0,
					tmp.getWidth(), tmp.getHeight());
			return tmp;
		}catch (Exception e){
			e.printStackTrace();
			Bitmap bitmap = Bitmap.createBitmap(100, 100, Bitmap.Config.ARGB_8888);
			bitmap.eraseColor(Color.WHITE);
			return bitmap;
		}
	}
	
	public static float[] loadBytesToGifImage(Context c, byte[] bytes, MobileImageView imageView, boolean resize) {
		float[] resizeImage = new float[]{0, 0};
		
		try {
			if (!GifUtils.isGif(bytes)) {
				Bitmap bitmap = Utils.getBitmapfromBytes(bytes);
				resizeImage = Utils.getProperSizeForIntertitialImage(c,
						bitmap);
				// float[] resizeImage = Utils.getProperSizeForFeaturedImage(c,
				// bitmap);

				Bitmap bitmapResult = bitmap;
				if(resize){
					bitmapResult = Bitmap.createScaledBitmap(bitmap,
							(int) resizeImage[0], (int) resizeImage[1], true);
				}

				if(imageView != null){
					imageView.setImageBitmap(bitmapResult);
				}

//			LayoutParams lp = imageView.getLayoutParams();
//			lp.width = newBitmap.getWidth();
//			lp.height = newBitmap.getHeight();
//			imageView.setLayoutParams(lp);
				return resizeImage;
			}

			if(imageView != null){
				imageView.setBytes(bytes);
				imageView.startAnimation();
			}
		}catch (Exception e){
			e.printStackTrace();
		}
		return resizeImage;
	}
}
